/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PixelInfoPane
extends JPanel {
    private BufferedImage image;
    private JLabel xCoord = new JLabel();
    private JLabel yCoord = new JLabel();
    private JLabel[] pixelValue = new JLabel[3];
    private int[] value = new int[3];

    public PixelInfoPane(BufferedImage bufferedImage) {
        this.image = bufferedImage;
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel("x"));
        Font font = new Font("Monospaced", 1, 12);
        this.xCoord.setFont(font);
        this.xCoord.setForeground(Color.black);
        jPanel.add(this.xCoord);
        jPanel.add(new JLabel("y"));
        this.yCoord.setFont(font);
        this.yCoord.setForeground(Color.black);
        jPanel.add(this.yCoord);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        this.add(jPanel);
        JPanel jPanel2 = new JPanel();
        if (this.image.getType() == 10 || this.image.getType() == 12) {
            jPanel2.add(new JLabel("grey level"));
            this.pixelValue[0] = new JLabel();
            this.pixelValue[0].setFont(font);
            this.pixelValue[0].setForeground(Color.black);
            jPanel2.add(this.pixelValue[0]);
        } else {
            jPanel2.add(new JLabel("RGB"));
            int n = 0;
            while (n < 3) {
                this.pixelValue[n] = new JLabel();
                this.pixelValue[n].setFont(font);
                this.pixelValue[n].setForeground(Color.black);
                jPanel2.add(this.pixelValue[n]);
                ++n;
            }
        }
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.add(jPanel2);
        this.updateInfo(new Point(0, 0));
    }

    public String formattedValue(int n) {
        if (n < 10) {
            return new String("  " + n);
        }
        if (n < 100) {
            return new String(" " + n);
        }
        return String.valueOf(n);
    }

    public void updateInfo(Point point) {
        if (this.validPixel(point)) {
            this.xCoord.setText(this.formattedValue(point.x));
            this.yCoord.setText(this.formattedValue(point.y));
            if (this.image.getType() == 10 || this.image.getType() == 12) {
                this.pixelValue[0].setText(this.formattedValue(this.image.getRaster().getSample(point.x, point.y, 0)));
            } else {
                this.image.getRaster().getPixel(point.x, point.y, this.value);
                int n = 0;
                while (n < 3) {
                    this.pixelValue[n].setText(this.formattedValue(this.value[n]));
                    ++n;
                }
            }
        }
    }

    public boolean validPixel(Point point) {
        return point.x >= 0 && point.x < this.image.getWidth() && point.y >= 0 && point.y < this.image.getHeight();
    }
}

