/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Magnifier
extends JDialog
implements ItemListener {
    private static final int VIEW_WIDTH = 128;
    private static final int VIEW_HEIGHT = 128;
    private static final int MAG_FACTOR = 2;
    private static final String[] MAG_OPTIONS = new String[]{" x2", " x3", " x4", " x5", " x6", " x7", " x8"};
    private ImageViewer viewer;
    private BufferedImage sourceImage;
    private ImageIcon viewedImage;
    private JLabel view;
    private Point centrePixel;
    private int magFactor = 2;

    public Magnifier(ImageViewer imageViewer, BufferedImage bufferedImage) {
        super(imageViewer, "Magnifier", false);
        this.viewer = imageViewer;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Magnifier.this.viewer.resetMagnifyButton();
            }
        });
        this.sourceImage = bufferedImage;
        this.viewedImage = new ImageIcon();
        this.centrePixel = new Point(bufferedImage.getWidth() / 2, bufferedImage.getHeight() / 2);
        this.updateView();
        JLabel jLabel = new JLabel(this.viewedImage);
        JComboBox<String> jComboBox = new JComboBox<String>(MAG_OPTIONS);
        jComboBox.addItemListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel("Magnification"));
        jPanel.add(jComboBox);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jLabel, "Center");
        jPanel2.add((Component)jPanel, "South");
        this.setContentPane(jPanel2);
        this.pack();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string = (String)itemEvent.getItem();
        this.magFactor = Integer.parseInt(string.substring(2));
        this.updateView();
    }

    public void updateView() {
        try {
            int n = 128 / this.magFactor;
            int n2 = 128 / this.magFactor;
            int n3 = this.centrePixel.x - n / 2;
            int n4 = this.centrePixel.y - n2 / 2;
            this.viewedImage.setImage(this.sourceImage.getSubimage(n3, n4, n, n2).getScaledInstance(128, 128, 2));
        }
        catch (RasterFormatException rasterFormatException) {
            Toolkit.getDefaultToolkit().beep();
        }
        this.repaint();
    }

    public void updateView(Point point) {
        this.centrePixel.setLocation(point);
        this.updateView();
    }
}

