/*
 * Decompiled with CFR 0.152.
 */
import com.pearsoneduc.ip.gui.ImageView;
import com.pearsoneduc.ip.gui.WindowMonitor;
import com.pearsoneduc.ip.io.ImageDecoder;
import com.pearsoneduc.ip.io.ImageDecoderException;
import com.pearsoneduc.ip.io.ImageFile;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;

public class ImageViewer
extends JFrame {
    private static final String MAGNIFIER_ICON = "magnify.gif";
    private BufferedImage image;
    private ImageView view;
    private Scroller scrollingView;
    private PixelInfoPane infoPane;
    private JToggleButton magnifyButton;
    private Magnifier magnifier;

    public ImageViewer(String string) throws IOException, ImageDecoderException {
        super(string);
        ImageDecoder imageDecoder = ImageFile.createImageDecoder((String)string);
        this.image = imageDecoder.decodeAsBufferedImage();
        this.view = new ImageView(this.image);
        this.scrollingView = new Scroller(this.view);
        this.infoPane = new PixelInfoPane(this.image);
        this.magnifier = new Magnifier(this, this.image);
        this.magnifyButton = new JToggleButton(new ImageIcon(this.getClass().getResource(MAGNIFIER_ICON)));
        this.magnifyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ImageViewer.this.magnifier.isVisible()) {
                    ((Component)ImageViewer.this.magnifier).setVisible(false);
                } else {
                    ((Component)ImageViewer.this.magnifier).setVisible(true);
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(this.infoPane);
        jPanel.add(this.magnifyButton);
        Container container = this.getContentPane();
        container.add((Component)this.scrollingView, "Center");
        container.add((Component)jPanel, "South");
        this.addWindowListener((WindowListener)new WindowMonitor());
    }

    static /* synthetic */ PixelInfoPane access$1(ImageViewer imageViewer) {
        return imageViewer.infoPane;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            try {
                ImageViewer imageViewer = new ImageViewer(stringArray[0]);
                imageViewer.pack();
                ((Component)imageViewer).setVisible(true);
            }
            catch (Exception exception) {
                System.err.println(exception);
                System.exit(1);
            }
        } else {
            System.err.println("usage: java ImageViewer <imagefile>");
            System.exit(1);
        }
    }

    public void resetMagnifyButton() {
        this.magnifyButton.getModel().setSelected(false);
    }

    class Scroller
    extends JScrollPane {
        public Scroller(ImageView imageView) {
            super((Component)imageView);
            this.addMouseMotionListener(new MouseMotionAdapter(this){
                private final /* synthetic */ Scroller this$1;
                {
                    this.this$1 = scroller;
                }

                public void mouseMoved(MouseEvent mouseEvent) {
                    ImageViewer.access$1(Scroller.access$0(this.this$1)).updateInfo(this.this$1.getPixelCoordinates(mouseEvent.getPoint()));
                }
            });
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ Scroller this$1;
                {
                    this.this$1 = scroller;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    ImageViewer.access$0(Scroller.access$0(this.this$1)).updateView(this.this$1.getPixelCoordinates(mouseEvent.getPoint()));
                }
            });
        }

        static /* synthetic */ ImageViewer access$0(Scroller scroller) {
            return scroller.ImageViewer.this;
        }

        public Point getPixelCoordinates(Point point) {
            Point point2 = this.getViewport().getViewPosition();
            Point point3 = new Point(point2.x + point.x, point2.y + point.y);
            return point3;
        }
    }
}

