/*
 * Decompiled with CFR 0.152.
 */
package com.pearsoneduc.ip.util;

public final class IntervalTimer {
    private static final boolean GC = false;
    private long startTime;
    private long endTime;
    private boolean timing;

    public double getElapsedTime() {
        if (this.timing) {
            long l = System.currentTimeMillis();
            return (double)(l - this.startTime) / 1000.0;
        }
        return (double)(this.endTime - this.startTime) / 1000.0;
    }

    public boolean isStopped() {
        return this.timing ^ true;
    }

    public boolean isTiming() {
        return this.timing;
    }

    public void reset() {
        this.endTime = 0L;
        this.startTime = 0L;
        this.timing = false;
    }

    public void start() {
        if (!this.timing) {
            this.startTime = System.currentTimeMillis();
            this.endTime = 0L;
            this.timing = true;
        }
    }

    public double stop() {
        if (this.timing) {
            this.endTime = System.currentTimeMillis();
            this.timing = false;
        }
        return (double)(this.endTime - this.startTime) / 1000.0;
    }

    public String toString() {
        if (this.startTime == 0L && this.endTime == 0L) {
            return new String(String.valueOf(this.getClass().getName()) + ": unused");
        }
        if (this.timing) {
            return new String(String.valueOf(this.getClass().getName()) + ": started " + this.startTime);
        }
        return new String(String.valueOf(this.getClass().getName()) + ": started " + this.startTime + ", stopped " + this.endTime);
    }
}

