/*
 * Decompiled with CFR 0.152.
 */
package com.pearsoneduc.ip.op;

import com.pearsoneduc.ip.op.GreyMapOp;
import java.awt.image.ImagingOpException;

public class ThresholdOp
extends GreyMapOp {
    public ThresholdOp(int n) {
        this.computeMapping(n, 255);
    }

    public ThresholdOp(int n, int n2) {
        this.computeMapping(n, n2);
    }

    public void computeMapping(int n, int n2) {
        if (n < 0 || n2 > 255 || n >= n2) {
            throw new ImagingOpException("invalid thresholds");
        }
        int n3 = 0;
        while (n3 < n) {
            this.table[n3] = 0;
            ++n3;
        }
        while (n3 <= n2) {
            this.table[n3] = -1;
            ++n3;
        }
        while (n3 < 256) {
            this.table[n3] = 0;
            ++n3;
        }
    }

    public void setThreshold(int n) {
        this.computeMapping(n, 255);
    }

    public void setThresholds(int n, int n2) {
        this.computeMapping(n, n2);
    }
}

