/*
 * Decompiled with CFR 0.152.
 */
package com.pearsoneduc.ip.op;

import com.pearsoneduc.ip.op.StructElementException;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;

public abstract class StructElement {
    protected int width;
    protected int height;
    protected Point origin;
    protected int[][] pixel;

    public StructElement() {
    }

    public StructElement(int n, int n2) throws StructElementException {
        if (n < 1 || n2 < 1) {
            throw new StructElementException("invalid structuring element dimensions");
        }
        this.width = n;
        this.height = n2;
        this.origin = new Point(n / 2, n2 / 2);
        this.pixel = new int[n2][n];
    }

    public StructElement(int n, int n2, Point point) throws StructElementException {
        this(n, n2);
        this.setOrigin(point);
    }

    public boolean equals(Object object) {
        if (object instanceof StructElement) {
            StructElement structElement = (StructElement)object;
            if (this.width != structElement.width || this.height != structElement.height || !this.origin.equals(structElement.origin)) {
                return false;
            }
            int n = 0;
            while (n < this.height) {
                int n2 = 0;
                while (n2 < this.width) {
                    if (this.pixel[n][n2] != structElement.pixel[n][n2]) {
                        return false;
                    }
                    ++n2;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public int getHeight() {
        return this.height;
    }

    public Point getOrigin(Point point) {
        if (point != null) {
            point.x = this.origin.x;
            point.y = this.origin.y;
            return point;
        }
        return new Point(this.origin.x, this.origin.y);
    }

    public int getPixel(int n, int n2) {
        return this.pixel[n2][n];
    }

    public int getWidth() {
        return this.width;
    }

    protected int readInt(BufferedReader bufferedReader, String string) throws IOException, StructElementException {
        String string2 = bufferedReader.readLine();
        if (!string2.startsWith(string)) {
            throw new StructElementException("cannot parse structuring element data");
        }
        int n = string2.indexOf(61);
        return Integer.parseInt(string2.substring(n + 1));
    }

    public void setOrigin(Point point) {
        this.origin.x = point.x;
        this.origin.y = point.y;
    }

    public abstract void setPixels(String var1) throws StructElementException;

    public abstract void setPixels(int[] var1) throws StructElementException;

    public abstract void setPixels(int[][] var1) throws StructElementException;

    public String toString() {
        return new String(String.valueOf(this.getClass().getName()) + ": size " + this.width + "x" + this.height + ", origin (" + this.origin.x + "," + this.origin.y + ")");
    }

    public abstract void write(Writer var1) throws IOException;

    public abstract void writePixels(Writer var1);
}

