/*
 * Decompiled with CFR 0.152.
 */
package com.pearsoneduc.ip.op;

import com.pearsoneduc.ip.util.StringTools;
import java.awt.image.Kernel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Vector;

public class StandardKernel
extends Kernel {
    private int numDigits;

    public StandardKernel(int n, int n2, float[] fArray) {
        this(n, n2, fArray, 4);
    }

    public StandardKernel(int n, int n2, float[] fArray, int n3) {
        super(n, n2, fArray);
        this.setFractionDigits(n3);
    }

    public static StandardKernel createKernel(Reader reader) throws IOException {
        return StandardKernel.createKernel(reader, false);
    }

    public static StandardKernel createKernel(Reader reader, boolean bl) throws IOException {
        StreamTokenizer streamTokenizer = new StreamTokenizer(new BufferedReader(reader));
        streamTokenizer.commentChar(35);
        int n = StandardKernel.getInteger(streamTokenizer);
        int n2 = StandardKernel.getInteger(streamTokenizer);
        if (n < 1 || n2 < 1) {
            throw new IOException("invalid kernel dimensions");
        }
        int n3 = StandardKernel.getInteger(streamTokenizer);
        int n4 = n * n2;
        float[] fArray = new float[n4];
        int n5 = 0;
        while (n5 < n4) {
            fArray[n5] = StandardKernel.getFloat(streamTokenizer);
            ++n5;
        }
        if (bl) {
            StandardKernel.normaliseCoefficients(fArray);
        }
        return new StandardKernel(n, n2, fArray, n3);
    }

    private static float getFloat(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == -2) {
            return (float)streamTokenizer.nval;
        }
        if (streamTokenizer.ttype == -1) {
            throw new EOFException("kernel appears to be truncated");
        }
        throw new IOException("invalid kernel data");
    }

    private NumberFormat getFormat() {
        StringBuffer stringBuffer = new StringBuffer("0");
        if (this.numDigits > 0) {
            stringBuffer.append('.');
            int n = 0;
            while (n < this.numDigits) {
                stringBuffer.append('0');
                ++n;
            }
        }
        return new DecimalFormat(stringBuffer.toString());
    }

    public int getFractionDigits() {
        return this.numDigits;
    }

    private static int getInteger(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == -2) {
            return (int)streamTokenizer.nval;
        }
        if (streamTokenizer.ttype == -1) {
            throw new EOFException("kernel appears to be truncated");
        }
        throw new IOException("invalid kernel data");
    }

    private static void normaliseCoefficients(float[] fArray) {
        float f = 0.0f;
        int n = 0;
        while (n < fArray.length) {
            f += fArray[n];
            ++n;
        }
        if (f > 1.001f) {
            int n2 = 0;
            while (n2 < fArray.length) {
                int n3 = n2++;
                fArray[n3] = fArray[n3] / f;
            }
        }
    }

    public void setFractionDigits(int n) {
        this.numDigits = Math.max(n, 0);
    }

    public String toString() {
        return new String(String.valueOf(this.getClass().getName()) + ": " + this.getWidth() + "x" + this.getHeight());
    }

    public void write(Writer writer) {
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(writer));
        printWriter.println("# convolution kernel");
        printWriter.println(String.valueOf(this.getWidth()) + " " + this.getHeight() + " " + this.numDigits);
        float[] fArray = this.getKernelData(null);
        NumberFormat numberFormat = this.getFormat();
        Vector<String> vector = new Vector<String>();
        int n = 0;
        int n2 = 0;
        while (n2 < fArray.length) {
            String string = numberFormat.format(fArray[n2]);
            vector.addElement(string);
            if (string.length() > n) {
                n = string.length();
            }
            ++n2;
        }
        n2 = 0;
        int n3 = 0;
        while (n3 < this.getHeight()) {
            int n4 = 0;
            while (n4 < this.getWidth()) {
                printWriter.print(StringTools.rightJustify((String)vector.elementAt(n2), n + 1));
                ++n4;
                ++n2;
            }
            printWriter.println();
            ++n3;
        }
        printWriter.flush();
    }
}

