/*
 * Decompiled with CFR 0.152.
 */
package com.pearsoneduc.ip.op;

import com.pearsoneduc.ip.op.StandardGreyOp;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class SobelEdgeOp
extends StandardGreyOp {
    public static final int SQRT_MAGNITUDE = 1;
    public static final int ABS_MAGNITUDE = 2;
    private int gradientThreshold = -1;
    private int magnitudeCalculation = 1;

    public SobelEdgeOp() {
    }

    public SobelEdgeOp(int n) {
        this.gradientThreshold = n;
    }

    public SobelEdgeOp(int n, int n2) {
        this.gradientThreshold = n;
        this.magnitudeCalculation = n2;
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.checkImage(bufferedImage);
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        }
        WritableRaster writableRaster = bufferedImage2.getRaster();
        float[] fArray = this.gradientMagnitude(bufferedImage);
        float f = fArray[0];
        int n = 1;
        while (n < fArray.length) {
            if (fArray[n] > f) {
                f = fArray[n];
            }
            ++n;
        }
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        float f2 = 255.0f / f;
        if (this.gradientThreshold >= 0) {
            int n4 = 1;
            while (n4 < n3 - 1) {
                int n5 = 1;
                while (n5 < n2 - 1) {
                    if (Math.round(f2 * fArray[n4 * n2 + n5]) >= this.gradientThreshold) {
                        writableRaster.setSample(n5, n4, 0, 255);
                    }
                    ++n5;
                }
                ++n4;
            }
        } else {
            int n6 = 1;
            while (n6 < n3 - 1) {
                int n7 = 1;
                while (n7 < n2 - 1) {
                    writableRaster.setSample(n7, n6, 0, Math.round(f2 * fArray[n6 * n2 + n7]));
                    ++n7;
                }
                ++n6;
            }
        }
        return bufferedImage2;
    }

    public int getGradientThreshold() {
        return this.gradientThreshold;
    }

    public int getMagnitudeCalculation() {
        return this.magnitudeCalculation;
    }

    protected float[] gradientMagnitude(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        float[] fArray = new float[n * n2];
        WritableRaster writableRaster = bufferedImage.getRaster();
        if (this.magnitudeCalculation == 2) {
            int n3 = 1;
            while (n3 < n2 - 1) {
                int n4 = 1;
                while (n4 < n - 1) {
                    int n5 = this.xGradient(writableRaster, n4, n3);
                    int n6 = this.yGradient(writableRaster, n4, n3);
                    fArray[n3 * n + n4] = Math.abs(n5) + Math.abs(n6);
                    ++n4;
                }
                ++n3;
            }
        } else {
            int n7 = 1;
            while (n7 < n2 - 1) {
                int n8 = 1;
                while (n8 < n - 1) {
                    int n9 = this.xGradient(writableRaster, n8, n7);
                    int n10 = this.yGradient(writableRaster, n8, n7);
                    fArray[n7 * n + n8] = (float)Math.sqrt(n9 * n9 + n10 * n10);
                    ++n8;
                }
                ++n7;
            }
        }
        return fArray;
    }

    protected final int xGradient(Raster raster, int n, int n2) {
        return raster.getSample(n - 1, n2 - 1, 0) + 2 * raster.getSample(n - 1, n2, 0) + raster.getSample(n - 1, n2 + 1, 0) - raster.getSample(n + 1, n2 - 1, 0) - 2 * raster.getSample(n + 1, n2, 0) - raster.getSample(n + 1, n2 + 1, 0);
    }

    protected final int yGradient(Raster raster, int n, int n2) {
        return raster.getSample(n - 1, n2 - 1, 0) + 2 * raster.getSample(n, n2 - 1, 0) + raster.getSample(n + 1, n2 - 1, 0) - raster.getSample(n - 1, n2 + 1, 0) - 2 * raster.getSample(n, n2 + 1, 0) - raster.getSample(n + 1, n2 + 1, 0);
    }
}

