/*
 * Decompiled with CFR 0.152.
 */
package com.pearsoneduc.ip.op;

import com.pearsoneduc.ip.op.StandardKernel;
import java.io.OutputStreamWriter;

public class SeparableGaussianKernel
extends StandardKernel {
    public SeparableGaussianKernel() {
        this(1.0f);
    }

    public SeparableGaussianKernel(float f) {
        super(SeparableGaussianKernel.getSize(f), 1, SeparableGaussianKernel.createKernelData(f));
    }

    public static float[] createKernelData(float f) {
        int n = (int)Math.ceil(4.0f * f);
        int n2 = 2 * n + 1;
        float[] fArray = new float[n2];
        double d = 2.0 * (double)f * (double)f;
        float f2 = 0.0f;
        int n3 = 0;
        int n4 = -n;
        while (n4 <= n) {
            fArray[n3] = (float)Math.exp((double)(-n4 * n4) / d);
            f2 += fArray[n3];
            ++n4;
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            int n5 = n3++;
            fArray[n5] = fArray[n5] / f2;
        }
        return fArray;
    }

    public static int getSize(float f) {
        int n = (int)Math.ceil(4.0f * f);
        return 2 * n + 1;
    }

    public static void main(String[] stringArray) {
        float f = 1.0f;
        if (stringArray.length > 0) {
            f = Float.valueOf(stringArray[0]).floatValue();
        }
        SeparableGaussianKernel separableGaussianKernel = new SeparableGaussianKernel(f);
        separableGaussianKernel.write(new OutputStreamWriter(System.out));
    }
}

