/*
 * Decompiled with CFR 0.152.
 */
package com.pearsoneduc.ip.op;

import com.pearsoneduc.ip.op.StandardGreyOp;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ImagingOpException;
import java.awt.image.WritableRaster;

public class RegionLabelOp
extends StandardGreyOp {
    private static final Point[] FOUR_CONNECTED = new Point[]{new Point(1, 0), new Point(0, -1), new Point(-1, 0), new Point(0, 1)};
    private static final Point[] EIGHT_CONNECTED = new Point[]{new Point(1, 0), new Point(1, -1), new Point(0, -1), new Point(-1, -1), new Point(-1, 0), new Point(-1, 1), new Point(0, 1), new Point(1, 1)};
    private static final int MAX_REGIONS = 255;
    private int connectivity;
    private Point[] delta;
    private int width;
    private int height;

    public RegionLabelOp(int n) {
        if (n == 4) {
            this.connectivity = 4;
            this.delta = FOUR_CONNECTED;
        } else if (n == 8) {
            this.connectivity = 8;
            this.delta = EIGHT_CONNECTED;
        } else {
            throw new ImagingOpException("connectivity must be 4 or 8");
        }
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.checkImage(bufferedImage);
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        }
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
        WritableRaster writableRaster = bufferedImage.copyData(null);
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        int n = 1;
        int n2 = 0;
        while (n2 < this.height) {
            int n3 = 0;
            while (n3 < this.width) {
                if (writableRaster.getSample(n3, n2, 0) > 0) {
                    this.label(writableRaster, writableRaster2, n3, n2, n);
                    if (++n > 255) {
                        return bufferedImage2;
                    }
                }
                ++n3;
            }
            ++n2;
        }
        return bufferedImage2;
    }

    private final boolean inImage(int n, int n2) {
        return n >= 0 && n < this.width && n2 >= 0 && n2 < this.height;
    }

    private void label(WritableRaster writableRaster, WritableRaster writableRaster2, int n, int n2, int n3) {
        writableRaster.setSample(n, n2, 0, 0);
        writableRaster2.setSample(n, n2, 0, n3);
        int n4 = 0;
        while (n4 < this.connectivity) {
            int n5 = n + this.delta[n4].x;
            int n6 = n2 + this.delta[n4].y;
            if (this.inImage(n5, n6) && writableRaster.getSample(n5, n6, 0) > 0) {
                this.label(writableRaster, writableRaster2, n5, n6, n3);
            }
            ++n4;
        }
    }
}

