/*
 * Decompiled with CFR 0.152.
 */
package com.pearsoneduc.ip.op;

import java.awt.Color;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Iterator;
import java.util.List;

public class RegionGrower {
    private static final Point[] FOUR_CONNECTED = new Point[]{new Point(1, 0), new Point(0, -1), new Point(-1, 0), new Point(0, 1)};
    private static final Point[] EIGHT_CONNECTED = new Point[]{new Point(1, 0), new Point(1, -1), new Point(0, -1), new Point(-1, -1), new Point(-1, 0), new Point(-1, 1), new Point(0, 1), new Point(1, 1)};
    private BufferedImage sourceImage;
    private List seedPixels;
    private int connectivity;
    private int squaredThreshold;
    private int width;
    private int height;
    private int numBands;
    private boolean[][] assigned;
    private short[][] border;
    private BufferedImage regionImage;
    private BufferedImage statusImage;
    private Color assignedColour = Color.red;
    private Color borderColour = Color.yellow;
    private Point[] delta;
    private int numRegions;
    private int[] regionSize;
    private int[][] regionSum;
    private int[][] regionMean;
    private boolean unassignedPixels = true;
    private int unassignedLastTime;
    private int unassigned = 0;
    private int numIterations = 0;
    private boolean monitorStatus;

    public RegionGrower(BufferedImage bufferedImage, List list, int n, int n2) {
        this(bufferedImage, list, n, n2, false);
    }

    public RegionGrower(BufferedImage bufferedImage, List list, int n, int n2, boolean bl) {
        this.sourceImage = bufferedImage;
        this.seedPixels = list;
        this.connectivity = n;
        this.squaredThreshold = n2 * n2;
        this.monitorStatus = bl;
        this.width = this.sourceImage.getWidth();
        this.height = this.sourceImage.getHeight();
        this.numBands = this.sourceImage.getRaster().getNumBands();
        this.assigned = new boolean[this.height][this.width];
        this.border = new short[this.height][this.width];
        this.regionImage = new BufferedImage(this.width, this.height, 10);
        if (this.monitorStatus) {
            this.statusImage = new BufferedImage(this.width, this.height, 2);
        }
        if (this.connectivity == 4) {
            this.delta = FOUR_CONNECTED;
        } else {
            this.connectivity = 8;
            this.delta = EIGHT_CONNECTED;
        }
        this.numRegions = this.seedPixels.size();
        this.regionSize = new int[this.numRegions];
        this.regionSum = new int[this.numRegions][this.numBands];
        this.regionMean = new int[this.numRegions][this.numBands];
        this.initialise();
    }

    private int countUnassignedPixels() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.height) {
            int n3 = 0;
            while (n3 < this.width) {
                if (!this.assigned[n2][n3]) {
                    ++n;
                }
                ++n3;
            }
            ++n2;
        }
        return n;
    }

    private int distanceFromMean(int n, int[] nArray) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.numBands) {
            int n4 = nArray[n3] - this.regionMean[n - 1][n3];
            n2 += n4 * n4;
            ++n3;
        }
        return n2;
    }

    public int getNumIterations() {
        return this.numIterations;
    }

    public int getNumRegions() {
        return this.numRegions;
    }

    public BufferedImage getRegionImage() {
        return this.regionImage;
    }

    public int getRegionSize(int n) {
        return n >= 0 && n < this.numRegions ? this.regionSize[n] : 0;
    }

    public BufferedImage getStatusImage() {
        return this.statusImage;
    }

    public void grow() {
        int[] nArray = new int[3];
        WritableRaster writableRaster = this.sourceImage.getRaster();
        WritableRaster writableRaster2 = this.regionImage.getRaster();
        short[][] sArray = new short[this.height][this.width];
        int n = 1;
        while (n < this.height - 1) {
            int n2 = 1;
            while (n2 < this.width - 1) {
                short s = this.border[n][n2];
                if (s != 0) {
                    int n3 = 0;
                    while (n3 < this.connectivity) {
                        int n4 = n + this.delta[n3].y;
                        int n5 = n2 + this.delta[n3].x;
                        if (!this.assigned[n4][n5]) {
                            writableRaster.getPixel(n5, n4, nArray);
                            if (this.distanceFromMean(s, nArray) < this.squaredThreshold) {
                                this.updateRegionStatistics(s, nArray);
                                writableRaster2.setSample(n5, n4, 0, s);
                                this.assigned[n4][n5] = true;
                                sArray[n4][n5] = s;
                                this.border[n][n2] = 0;
                            }
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            ++n;
        }
        this.border = sArray;
        if (this.monitorStatus) {
            this.updateStatusImage();
        }
        this.unassignedLastTime = this.unassigned;
        this.unassigned = this.countUnassignedPixels();
        this.unassignedPixels = this.unassignedLastTime - this.unassigned != 0;
        ++this.numIterations;
    }

    public void growToCompletion() {
        while (this.unassignedPixels) {
            this.grow();
        }
    }

    private void initialise() {
        int n;
        Iterator iterator = this.seedPixels.iterator();
        WritableRaster writableRaster = this.sourceImage.getRaster();
        WritableRaster writableRaster2 = this.regionImage.getRaster();
        if (this.monitorStatus) {
            int n2 = 0;
            while (n2 < this.height) {
                n = 0;
                while (n < this.width) {
                    this.statusImage.setRGB(n, n2, 0);
                    ++n;
                }
                ++n2;
            }
        }
        int[] nArray = new int[3];
        n = 1;
        while (iterator.hasNext()) {
            Point point = (Point)iterator.next();
            writableRaster2.setSample(point.x, point.y, 0, n);
            if (this.monitorStatus) {
                this.statusImage.setRGB(point.x, point.y, this.borderColour.getRGB());
            }
            this.border[point.y][point.x] = n;
            this.assigned[point.y][point.x] = true;
            int n3 = n - 1;
            this.regionSize[n3] = this.regionSize[n3] + 1;
            writableRaster.getPixel(point.x, point.y, nArray);
            int n4 = 0;
            while (n4 < this.numBands) {
                int n5 = nArray[n4];
                this.regionSum[n - 1][n4] = n5;
                this.regionMean[n - 1][n4] = n5;
                ++n4;
            }
            n = (short)(n + 1);
        }
    }

    public boolean isFinished() {
        return this.unassignedPixels ^ true;
    }

    public boolean isNotFinished() {
        return this.unassignedPixels;
    }

    public void setAssignedColour(Color color) {
        this.assignedColour = color;
    }

    public void setBorderColour(Color color) {
        this.borderColour = color;
    }

    private void updateRegionStatistics(int n, int[] nArray) {
        int n2 = n - 1;
        this.regionSize[n2] = this.regionSize[n2] + 1;
        int n3 = 0;
        while (n3 < this.numBands) {
            int[] nArray2 = this.regionSum[n - 1];
            int n4 = n3;
            nArray2[n4] = nArray2[n4] + nArray[n3];
            this.regionMean[n - 1][n3] = this.regionSum[n - 1][n3] / this.regionSize[n - 1];
            ++n3;
        }
    }

    private void updateStatusImage() {
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                if (this.border[n][n2] > 0) {
                    this.statusImage.setRGB(n2, n, this.borderColour.getRGB());
                } else if (this.assigned[n][n2]) {
                    this.statusImage.setRGB(n2, n, this.assignedColour.getRGB());
                }
                ++n2;
            }
            ++n;
        }
    }
}

