/*
 * Decompiled with CFR 0.152.
 */
package com.pearsoneduc.ip.op;

import com.pearsoneduc.ip.op.StandardGreyOp;
import java.awt.image.ImagingOpException;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class NeighbourhoodOp
extends StandardGreyOp {
    public static final int NO_BORDER_OP = 1;
    public static final int COPY_BORDER_PIXELS = 2;
    public static final int REFLECTED_INDEXING = 3;
    public static final int CIRCULAR_INDEXING = 4;
    protected int width;
    protected int height;
    protected int size;
    protected int borderStrategy;

    public NeighbourhoodOp(int n, int n2, int n3) {
        if (n < 1 || n2 < 1 || n % 2 == 0 || n2 % 2 == 0) {
            throw new ImagingOpException("invalid neighbourhood dimensions");
        }
        this.width = n;
        this.height = n2;
        this.size = n * n2;
        this.borderStrategy = n3;
    }

    public static final int circIndex(int n, int n2) {
        if (n < 0) {
            return n + n2;
        }
        if (n >= n2) {
            return n - n2;
        }
        return n;
    }

    protected void copyBorders(Raster raster, WritableRaster writableRaster) {
        int n;
        int n2;
        int n3 = raster.getWidth();
        int n4 = raster.getHeight();
        int n5 = this.width / 2;
        int n6 = this.height / 2;
        int n7 = 0;
        while (n7 < n3) {
            n2 = 0;
            while (n2 < n6) {
                writableRaster.setSample(n7, n2, 0, raster.getSample(n7, n2, 0));
                ++n2;
            }
            n = n4 - n6;
            while (n < n4) {
                writableRaster.setSample(n7, n, 0, raster.getSample(n7, n, 0));
                ++n;
            }
            ++n7;
        }
        n2 = 0;
        while (n2 < n4) {
            n = 0;
            while (n < n5) {
                writableRaster.setSample(n, n2, 0, raster.getSample(n, n2, 0));
                ++n;
            }
            int n8 = n3 - n5;
            while (n8 < n3) {
                writableRaster.setSample(n8, n2, 0, raster.getSample(n8, n2, 0));
                ++n8;
            }
            ++n2;
        }
    }

    public int getBorderStrategy() {
        return this.borderStrategy;
    }

    public int getHeight() {
        return this.height;
    }

    public int getNumPixels() {
        return this.size;
    }

    public int getWidth() {
        return this.width;
    }

    public static final int refIndex(int n, int n2) {
        if (n < 0) {
            return -n - 1;
        }
        if (n >= n2) {
            return 2 * n2 - n - 1;
        }
        return n;
    }
}

