/*
 * Decompiled with CFR 0.152.
 */
package com.pearsoneduc.ip.op;

import com.pearsoneduc.ip.op.NeighbourhoodOp;
import java.awt.image.BufferedImage;
import java.awt.image.ImagingOpException;
import java.awt.image.WritableRaster;

public class MMSEFilterOp
extends NeighbourhoodOp {
    private float noiseVariance;
    private float[] neighbourhood;

    public MMSEFilterOp(float f) {
        this(f, 3, 3, 1);
    }

    public MMSEFilterOp(float f, int n, int n2) {
        this(f, n, n2, 1);
    }

    public MMSEFilterOp(float f, int n, int n2, int n3) {
        super(n, n2, n3);
        if (f <= 0.0f) {
            throw new ImagingOpException("noise variance must be greater than zero");
        }
        this.noiseVariance = f;
        this.neighbourhood = new float[this.size];
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.checkImage(bufferedImage);
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        int n3 = this.width / 2;
        int n4 = this.height / 2;
        switch (this.borderStrategy) {
            case 3: {
                int n5 = 0;
                while (n5 < n2) {
                    int n6 = 0;
                    while (n6 < n) {
                        int n7 = 0;
                        int n8 = -n4;
                        while (n8 <= n4) {
                            int n9 = -n3;
                            while (n9 <= n3) {
                                this.neighbourhood[n7] = writableRaster.getSample(NeighbourhoodOp.refIndex(n6 + n9, n), NeighbourhoodOp.refIndex(n5 + n8, n2), 0);
                                ++n9;
                                ++n7;
                            }
                            ++n8;
                        }
                        writableRaster2.setSample(n6, n5, 0, this.filterValue());
                        ++n6;
                    }
                    ++n5;
                }
                break;
            }
            case 4: {
                int n10 = 0;
                while (n10 < n2) {
                    int n11 = 0;
                    while (n11 < n) {
                        int n12 = 0;
                        int n13 = -n4;
                        while (n13 <= n4) {
                            int n14 = -n3;
                            while (n14 <= n3) {
                                this.neighbourhood[n12] = writableRaster.getSample(NeighbourhoodOp.circIndex(n11 + n14, n), NeighbourhoodOp.circIndex(n10 + n13, n2), 0);
                                ++n14;
                                ++n12;
                            }
                            ++n13;
                        }
                        writableRaster2.setSample(n11, n10, 0, this.filterValue());
                        ++n11;
                    }
                    ++n10;
                }
                break;
            }
            case 2: {
                this.copyBorders(writableRaster, writableRaster2);
            }
            default: {
                int n15 = n4;
                while (n15 < n2 - n4) {
                    int n16 = n3;
                    while (n16 < n - n3) {
                        int n17 = 0;
                        int n18 = -n4;
                        while (n18 <= n4) {
                            int n19 = -n3;
                            while (n19 <= n3) {
                                this.neighbourhood[n17] = writableRaster.getSample(n16 + n19, n15 + n18, 0);
                                ++n19;
                                ++n17;
                            }
                            ++n18;
                        }
                        writableRaster2.setSample(n16, n15, 0, this.filterValue());
                        ++n16;
                    }
                    ++n15;
                }
                break block0;
            }
        }
        return bufferedImage2;
    }

    private int filterValue() {
        float f = 0.0f;
        int n = 0;
        while (n < this.size) {
            f += this.neighbourhood[n];
            ++n;
        }
        float f2 = f / (float)this.size;
        f = 0.0f;
        int n2 = 0;
        while (n2 < this.size) {
            f += (this.neighbourhood[n2] - f2) * (this.neighbourhood[n2] - f2);
            ++n2;
        }
        float f3 = f / (float)this.size;
        try {
            float f4 = this.noiseVariance / f3;
            if (f4 > 1.0f) {
                return Math.round(f2);
            }
            int n3 = Math.round((1.0f - f4) * this.neighbourhood[this.size / 2] + f4 * f2);
            return Math.max(0, Math.min(255, n3));
        }
        catch (ArithmeticException arithmeticException) {
            return Math.round(f2);
        }
    }
}

