/*
 * Decompiled with CFR 0.152.
 */
package com.pearsoneduc.ip.op;

import com.pearsoneduc.ip.op.FFTException;
import com.pearsoneduc.ip.util.Complex;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public class ImageFFT {
    public static final int NO_WINDOW = 1;
    public static final int BARTLETT_WINDOW = 2;
    public static final int HAMMING_WINDOW = 3;
    public static final int HANNING_WINDOW = 4;
    private static final String NO_DATA = "no spectral data available";
    private static final String INVALID_PARAMS = "invalid filter parameters";
    private static final double TWO_PI = Math.PI * 2;
    private Complex[] data;
    private int log2w;
    private int log2h;
    private int width;
    private int height;
    private int window;
    private boolean spectral = false;

    public ImageFFT(BufferedImage bufferedImage) throws FFTException {
        this(bufferedImage, 1);
    }

    public ImageFFT(BufferedImage bufferedImage, int n) throws FFTException {
        if (bufferedImage.getType() != 10) {
            throw new FFTException("image must be 8-bit greyscale");
        }
        this.log2w = ImageFFT.powerOfTwo(bufferedImage.getWidth());
        this.log2h = ImageFFT.powerOfTwo(bufferedImage.getHeight());
        this.width = 1 << this.log2w;
        this.height = 1 << this.log2h;
        this.window = n;
        this.data = new Complex[this.width * this.height];
        int n2 = 0;
        while (n2 < this.data.length) {
            this.data[n2] = new Complex();
            ++n2;
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        double d = (double)bufferedImage.getWidth() / 2.0;
        double d2 = (double)bufferedImage.getHeight() / 2.0;
        double d3 = Math.min(d, d2);
        switch (this.window) {
            case 3: {
                int n3 = 0;
                while (n3 < bufferedImage.getHeight()) {
                    int n4 = 0;
                    while (n4 < bufferedImage.getWidth()) {
                        double d4 = Math.sqrt(((double)n4 - d) * ((double)n4 - d) + ((double)n3 - d2) * ((double)n3 - d2));
                        this.data[n3 * this.width + n4].re = (float)(ImageFFT.hammingWindow(d4, d3) * (double)writableRaster.getSample(n4, n3, 0));
                        ++n4;
                    }
                    ++n3;
                }
                break;
            }
            case 4: {
                int n5 = 0;
                while (n5 < bufferedImage.getHeight()) {
                    int n6 = 0;
                    while (n6 < bufferedImage.getWidth()) {
                        double d5 = Math.sqrt(((double)n6 - d) * ((double)n6 - d) + ((double)n5 - d2) * ((double)n5 - d2));
                        this.data[n5 * this.width + n6].re = (float)(ImageFFT.hanningWindow(d5, d3) * (double)writableRaster.getSample(n6, n5, 0));
                        ++n6;
                    }
                    ++n5;
                }
                break;
            }
            case 2: {
                int n7 = 0;
                while (n7 < bufferedImage.getHeight()) {
                    int n8 = 0;
                    while (n8 < bufferedImage.getWidth()) {
                        double d6 = Math.sqrt(((double)n8 - d) * ((double)n8 - d) + ((double)n7 - d2) * ((double)n7 - d2));
                        this.data[n7 * this.width + n8].re = (float)(ImageFFT.bartlettWindow(d6, d3) * (double)writableRaster.getSample(n8, n7, 0));
                        ++n8;
                    }
                    ++n7;
                }
                break;
            }
            default: {
                int n9 = 0;
                while (n9 < bufferedImage.getHeight()) {
                    int n10 = 0;
                    while (n10 < bufferedImage.getWidth()) {
                        this.data[n9 * this.width + n10].re = writableRaster.getSample(n10, n9, 0);
                        ++n10;
                    }
                    ++n9;
                }
                break block0;
            }
        }
    }

    public static final double bartlettWindow(double d, double d2) {
        return 1.0 - Math.min(d, d2) / d2;
    }

    public void butterworthBandPassFilter(double d, double d2) throws FFTException {
        this.butterworthBandPassFilter(1, d, d2);
    }

    public void butterworthBandPassFilter(int n, double d, double d2) throws FFTException {
        if (!this.spectral) {
            throw new FFTException(NO_DATA);
        }
        double d3 = d2 / 2.0;
        if (n < 1 || d - d3 <= 0.0 || d + d3 > 1.0) {
            throw new FFTException(INVALID_PARAMS);
        }
        int n2 = this.width / 2;
        int n3 = this.height / 2;
        int n4 = 0;
        double d4 = Math.min(n2, n3);
        int n5 = 0;
        while (n5 < this.height) {
            int n6 = ImageFFT.shift(n5, n3) - n3;
            int n7 = 0;
            while (n7 < this.width) {
                int n8 = ImageFFT.shift(n7, n2) - n2;
                double d5 = Math.sqrt(n8 * n8 + n6 * n6) / d4;
                double d6 = ImageFFT.butterworthBandPassFunction(n, d, d2, d5) * (double)this.data[n4].getMagnitude();
                this.data[n4].setPolar(d6, this.data[n4].getPhase());
                ++n7;
                ++n4;
            }
            ++n5;
        }
    }

    public static final double butterworthBandPassFunction(int n, double d, double d2, double d3) {
        return 1.0 - ImageFFT.butterworthBandStopFunction(n, d, d2, d3);
    }

    public void butterworthBandStopFilter(double d, double d2) throws FFTException {
        this.butterworthBandStopFilter(1, d, d2);
    }

    public void butterworthBandStopFilter(int n, double d, double d2) throws FFTException {
        if (!this.spectral) {
            throw new FFTException(NO_DATA);
        }
        double d3 = d2 / 2.0;
        if (n < 1 || d - d3 <= 0.0 || d + d3 > 1.0) {
            throw new FFTException(INVALID_PARAMS);
        }
        int n2 = this.width / 2;
        int n3 = this.height / 2;
        int n4 = 0;
        double d4 = Math.min(n2, n3);
        int n5 = 0;
        while (n5 < this.height) {
            int n6 = ImageFFT.shift(n5, n3) - n3;
            int n7 = 0;
            while (n7 < this.width) {
                int n8 = ImageFFT.shift(n7, n2) - n2;
                double d5 = Math.sqrt(n8 * n8 + n6 * n6) / d4;
                double d6 = ImageFFT.butterworthBandStopFunction(n, d, d2, d5) * (double)this.data[n4].getMagnitude();
                this.data[n4].setPolar(d6, this.data[n4].getPhase());
                ++n7;
                ++n4;
            }
            ++n5;
        }
    }

    public static final double butterworthBandStopFunction(int n, double d, double d2, double d3) {
        try {
            double d4 = Math.pow(d2 * d / (d3 * d3 - d * d), 2.0 * (double)n);
            return 1.0 / (1.0 + d4);
        }
        catch (ArithmeticException arithmeticException) {
            return 0.0;
        }
    }

    public void butterworthHighPassFilter(double d) throws FFTException {
        this.butterworthHighPassFilter(1, d);
    }

    public void butterworthHighPassFilter(int n, double d) throws FFTException {
        if (!this.spectral) {
            throw new FFTException(NO_DATA);
        }
        if (n < 1 || d <= 0.0 || d > 1.0) {
            throw new FFTException(INVALID_PARAMS);
        }
        int n2 = this.width / 2;
        int n3 = this.height / 2;
        int n4 = 0;
        double d2 = Math.min(n2, n3);
        int n5 = 0;
        while (n5 < this.height) {
            int n6 = ImageFFT.shift(n5, n3) - n3;
            int n7 = 0;
            while (n7 < this.width) {
                int n8 = ImageFFT.shift(n7, n2) - n2;
                double d3 = Math.sqrt(n8 * n8 + n6 * n6) / d2;
                double d4 = ImageFFT.butterworthHighPassFunction(n, d, d3) * (double)this.data[n4].getMagnitude();
                this.data[n4].setPolar(d4, this.data[n4].getPhase());
                ++n7;
                ++n4;
            }
            ++n5;
        }
    }

    public static final double butterworthHighPassFunction(int n, double d, double d2) {
        try {
            double d3 = Math.pow(d / d2, 2.0 * (double)n);
            return 1.0 / (1.0 + d3);
        }
        catch (ArithmeticException arithmeticException) {
            return 0.0;
        }
    }

    public void butterworthLowPassFilter(double d) throws FFTException {
        this.butterworthLowPassFilter(1, d);
    }

    public void butterworthLowPassFilter(int n, double d) throws FFTException {
        if (!this.spectral) {
            throw new FFTException(NO_DATA);
        }
        if (n < 1 || d <= 0.0 || d > 1.0) {
            throw new FFTException(INVALID_PARAMS);
        }
        int n2 = this.width / 2;
        int n3 = this.height / 2;
        int n4 = 0;
        double d2 = Math.min(n2, n3);
        int n5 = 0;
        while (n5 < this.height) {
            int n6 = ImageFFT.shift(n5, n3) - n3;
            int n7 = 0;
            while (n7 < this.width) {
                int n8 = ImageFFT.shift(n7, n2) - n2;
                double d3 = Math.sqrt(n8 * n8 + n6 * n6) / d2;
                double d4 = ImageFFT.butterworthLowPassFunction(n, d, d3) * (double)this.data[n4].getMagnitude();
                this.data[n4].setPolar(d4, this.data[n4].getPhase());
                ++n7;
                ++n4;
            }
            ++n5;
        }
    }

    public static final double butterworthLowPassFunction(int n, double d, double d2) {
        double d3 = Math.pow(d2 / d, 2.0 * (double)n);
        return 1.0 / (1.0 + d3);
    }

    private float calculateMagnitudes(float[] fArray) {
        float f = 0.0f;
        int n = 0;
        while (n < this.data.length) {
            fArray[n] = this.data[n].getMagnitude();
            if (fArray[n] > f) {
                f = fArray[n];
            }
            ++n;
        }
        return f;
    }

    private static void fft(Complex[] complexArray, int n, int n2, int n3) {
        int n4;
        int n5 = 1;
        int n6 = 0;
        while (n6 < n2) {
            int n7 = n5;
            double d = Math.PI * -2 / (double)(n5 <<= 1) * (double)n3;
            double d2 = Math.sin(0.5 * d);
            double d3 = -2.0 * d2 * d2;
            double d4 = Math.sin(d);
            double d5 = 1.0;
            double d6 = 0.0;
            n4 = 0;
            while (n4 < n7) {
                int n8 = n4;
                while (n8 < n) {
                    int n9 = n8 + n7;
                    double d7 = d5 * (double)complexArray[n9].re - d6 * (double)complexArray[n9].im;
                    double d8 = d6 * (double)complexArray[n9].re + d5 * (double)complexArray[n9].im;
                    complexArray[n9].re = (float)((double)complexArray[n8].re - d7);
                    complexArray[n8].re += (float)d7;
                    complexArray[n9].im = (float)((double)complexArray[n8].im - d8);
                    complexArray[n8].im += (float)d8;
                    n8 += n5;
                }
                d2 = d5;
                d5 = d2 * d3 - d6 * d4 + d5;
                d6 = d6 * d3 + d2 * d4 + d6;
                ++n4;
            }
            ++n6;
        }
        if (n3 == -1) {
            n4 = 0;
            while (n4 < n) {
                complexArray[n4].re /= (float)n;
                complexArray[n4].im /= (float)n;
                ++n4;
            }
        }
    }

    public int getHeight() {
        return this.height;
    }

    public float getMagnitude(int n, int n2) throws FFTException {
        if (!this.spectral) {
            throw new FFTException(NO_DATA);
        }
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            return this.data[n2 * this.width + n].getMagnitude();
        }
        return 0.0f;
    }

    public float getPhase(int n, int n2) throws FFTException {
        if (!this.spectral) {
            throw new FFTException(NO_DATA);
        }
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            return this.data[n2 * this.width + n].getPhase();
        }
        return 0.0f;
    }

    public BufferedImage getSpectrum() throws FFTException {
        if (!this.spectral) {
            throw new FFTException(NO_DATA);
        }
        float[] fArray = new float[this.width * this.height];
        float f = this.calculateMagnitudes(fArray);
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 10);
        WritableRaster writableRaster = bufferedImage.getRaster();
        double d = 255.0 / Math.log((double)f + 1.0);
        int n = this.width / 2;
        int n2 = this.height / 2;
        int n3 = 0;
        while (n3 < this.height) {
            int n4 = ImageFFT.shift(n3, n2);
            int n5 = 0;
            while (n5 < this.width) {
                int n6 = ImageFFT.shift(n5, n);
                int n7 = (int)Math.round(d * Math.log((double)fArray[n4 * this.width + n6] + 1.0));
                writableRaster.setSample(n5, n3, 0, n7);
                ++n5;
            }
            ++n3;
        }
        return bufferedImage;
    }

    public BufferedImage getUnshiftedSpectrum() throws FFTException {
        if (!this.spectral) {
            throw new FFTException(NO_DATA);
        }
        float[] fArray = new float[this.width * this.height];
        float f = this.calculateMagnitudes(fArray);
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 10);
        WritableRaster writableRaster = bufferedImage.getRaster();
        double d = 255.0 / Math.log((double)f + 1.0);
        int n = 0;
        int n2 = 0;
        while (n2 < this.height) {
            int n3 = 0;
            while (n3 < this.width) {
                int n4 = (int)Math.round(d * Math.log((double)fArray[n] + 1.0));
                writableRaster.setSample(n3, n2, 0, n4);
                ++n3;
                ++n;
            }
            ++n2;
        }
        return bufferedImage;
    }

    public int getWidth() {
        return this.width;
    }

    public int getWindow() {
        return this.window;
    }

    public static final double hammingWindow(double d, double d2) {
        double d3 = (d2 - Math.min(d, d2)) / d2;
        return 0.54 - 0.46 * Math.cos(d3 * Math.PI);
    }

    public static final double hanningWindow(double d, double d2) {
        double d3 = (d2 - Math.min(d, d2)) / d2;
        return 0.5 - 0.5 * Math.cos(d3 * Math.PI);
    }

    public void idealBandPassFilter(double d, double d2) throws FFTException {
        if (!this.spectral) {
            throw new FFTException(NO_DATA);
        }
        double d3 = d2 / 2.0;
        double d4 = d - d3;
        double d5 = d + d3;
        if (d4 < 0.0 || d5 > 1.0) {
            throw new FFTException(INVALID_PARAMS);
        }
        int n = this.width / 2;
        int n2 = this.height / 2;
        int n3 = 0;
        double d6 = Math.min(n, n2);
        int n4 = 0;
        while (n4 < this.height) {
            int n5 = ImageFFT.shift(n4, n2) - n2;
            int n6 = 0;
            while (n6 < this.width) {
                int n7 = ImageFFT.shift(n6, n) - n;
                double d7 = Math.sqrt(n7 * n7 + n5 * n5) / d6;
                if (d7 < d4 || d7 > d5) {
                    this.data[n3].im = 0.0f;
                    this.data[n3].re = 0.0f;
                }
                ++n6;
                ++n3;
            }
            ++n4;
        }
    }

    public void idealBandStopFilter(double d, double d2) throws FFTException {
        if (!this.spectral) {
            throw new FFTException(NO_DATA);
        }
        double d3 = d2 / 2.0;
        double d4 = d - d3;
        double d5 = d + d3;
        if (d4 < 0.0 || d5 > 1.0) {
            throw new FFTException(INVALID_PARAMS);
        }
        int n = this.width / 2;
        int n2 = this.height / 2;
        int n3 = 0;
        double d6 = Math.min(n, n2);
        int n4 = 0;
        while (n4 < this.height) {
            int n5 = ImageFFT.shift(n4, n2) - n2;
            int n6 = 0;
            while (n6 < this.width) {
                int n7 = ImageFFT.shift(n6, n) - n;
                double d7 = Math.sqrt(n7 * n7 + n5 * n5) / d6;
                if (d7 >= d4 && d7 <= d5) {
                    this.data[n3].im = 0.0f;
                    this.data[n3].re = 0.0f;
                }
                ++n6;
                ++n3;
            }
            ++n4;
        }
    }

    public void idealHighPassFilter(double d) throws FFTException {
        if (!this.spectral) {
            throw new FFTException(NO_DATA);
        }
        if (d < 0.0 || d > 1.0) {
            throw new FFTException("invalid filter radius");
        }
        int n = this.width / 2;
        int n2 = this.height / 2;
        int n3 = 0;
        double d2 = Math.min(n, n2);
        int n4 = 0;
        while (n4 < this.height) {
            int n5 = ImageFFT.shift(n4, n2) - n2;
            int n6 = 0;
            while (n6 < this.width) {
                int n7 = ImageFFT.shift(n6, n) - n;
                double d3 = Math.sqrt(n7 * n7 + n5 * n5) / d2;
                if (d3 < d) {
                    this.data[n3].im = 0.0f;
                    this.data[n3].re = 0.0f;
                }
                ++n6;
                ++n3;
            }
            ++n4;
        }
    }

    public void idealLowPassFilter(double d) throws FFTException {
        if (!this.spectral) {
            throw new FFTException(NO_DATA);
        }
        if (d < 0.0 || d > 1.0) {
            throw new FFTException("invalid filter radius");
        }
        int n = this.width / 2;
        int n2 = this.height / 2;
        int n3 = 0;
        double d2 = Math.min(n, n2);
        int n4 = 0;
        while (n4 < this.height) {
            int n5 = ImageFFT.shift(n4, n2) - n2;
            int n6 = 0;
            while (n6 < this.width) {
                int n7 = ImageFFT.shift(n6, n) - n;
                double d3 = Math.sqrt(n7 * n7 + n5 * n5) / d2;
                if (d3 > d) {
                    this.data[n3].im = 0.0f;
                    this.data[n3].re = 0.0f;
                }
                ++n6;
                ++n3;
            }
            ++n4;
        }
    }

    public boolean isSpectral() {
        return this.spectral;
    }

    private static int powerOfTwo(int n) {
        int n2 = 0;
        int n3 = 1;
        while (n3 < n) {
            n3 <<= 1;
            ++n2;
        }
        return n2;
    }

    private static void reorder(Complex[] complexArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (n3 > n2) {
                complexArray[n3].swapWith(complexArray[n2]);
            }
            int n4 = n >> 1;
            while (n2 >= n4 && n4 >= 2) {
                n2 -= n4;
                n4 >>= 1;
            }
            n2 += n4;
            ++n3;
        }
    }

    public void setMagnitude(int n, int n2, float f) throws FFTException {
        if (!this.spectral) {
            throw new FFTException(NO_DATA);
        }
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            int n3 = n2 * this.width + n;
            this.data[n3].setPolar(f, this.data[n3].getPhase());
        }
    }

    public void setPhase(int n, int n2, float f) throws FFTException {
        if (!this.spectral) {
            throw new FFTException(NO_DATA);
        }
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            int n3 = n2 * this.width + n;
            this.data[n3].setPolar(this.data[n3].getMagnitude(), f);
        }
    }

    private static final int shift(int n, int n2) {
        return n >= n2 ? n - n2 : n + n2;
    }

    public BufferedImage toImage(BufferedImage bufferedImage) throws FFTException {
        return this.toImage(bufferedImage, 0);
    }

    public BufferedImage toImage(BufferedImage bufferedImage, int n) throws FFTException {
        int n2;
        int n3;
        if (this.spectral) {
            throw new FFTException("cannot transfer spectral data to an image");
        }
        if (bufferedImage == null) {
            bufferedImage = new BufferedImage(this.width, this.height, 10);
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n4 = Math.min(bufferedImage.getWidth(), this.width);
        int n5 = Math.min(bufferedImage.getHeight(), this.height);
        if (n4 < bufferedImage.getWidth() || n5 < bufferedImage.getHeight()) {
            n3 = 0;
            while (n3 < bufferedImage.getHeight()) {
                n2 = 0;
                while (n2 < bufferedImage.getWidth()) {
                    writableRaster.setSample(n2, n3, 0, 0);
                    ++n2;
                }
                ++n3;
            }
        }
        n3 = 0;
        int n6 = 0;
        while (n6 < this.height) {
            int n7 = 0;
            while (n7 < this.width) {
                n2 = Math.max(0, Math.min(255, n + Math.round(this.data[n3].re)));
                writableRaster.setSample(n7, n6, 0, n2);
                ++n7;
                ++n3;
            }
            ++n6;
        }
        return bufferedImage;
    }

    public String toString() {
        String string = new String(String.valueOf(this.getClass().getName()) + ": " + this.width + "x" + this.height + (this.spectral ? ", frequency domain" : ", spatial domain"));
        return string;
    }

    public void transform() {
        int n;
        Complex[] complexArray = new Complex[this.width];
        int n2 = 0;
        while (n2 < this.width) {
            complexArray[n2] = new Complex();
            ++n2;
        }
        Complex[] complexArray2 = new Complex[this.height];
        int n3 = 0;
        while (n3 < this.height) {
            complexArray2[n3] = new Complex();
            ++n3;
        }
        int n4 = this.spectral ? -1 : 1;
        n3 = 0;
        while (n3 < this.height) {
            n = n3 * this.width;
            n2 = 0;
            while (n2 < this.width) {
                complexArray[n2].re = this.data[n].re;
                complexArray[n2].im = this.data[n].im;
                ++n2;
                ++n;
            }
            ImageFFT.reorder(complexArray, this.width);
            ImageFFT.fft(complexArray, this.width, this.log2w, n4);
            n = n3 * this.width;
            n2 = 0;
            while (n2 < this.width) {
                this.data[n].re = complexArray[n2].re;
                this.data[n].im = complexArray[n2].im;
                ++n2;
                ++n;
            }
            ++n3;
        }
        n2 = 0;
        while (n2 < this.width) {
            n = n2;
            n3 = 0;
            while (n3 < this.height) {
                complexArray2[n3].re = this.data[n].re;
                complexArray2[n3].im = this.data[n].im;
                ++n3;
                n += this.width;
            }
            ImageFFT.reorder(complexArray2, this.height);
            ImageFFT.fft(complexArray2, this.height, this.log2h, n4);
            n = n2;
            n3 = 0;
            while (n3 < this.height) {
                this.data[n].re = complexArray2[n3].re;
                this.data[n].im = complexArray2[n3].im;
                ++n3;
                n += this.width;
            }
            ++n2;
        }
        this.spectral = !this.spectral;
    }
}

