/*
 * Decompiled with CFR 0.152.
 */
package com.pearsoneduc.ip.op;

import com.pearsoneduc.ip.op.HistogramException;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.Writer;

public final class Histogram
implements Cloneable {
    private static final String BAND_ERROR = "histogram band not specified";
    private int bands;
    private int samples;
    private int[][] freq;
    private int[][] cumFreq;
    private int[] minValue;
    private int[] maxValue;
    private int[] minFreq;
    private int[] maxFreq;
    private double[] meanValue;

    public Histogram() {
        this.allocateStorage();
    }

    public Histogram(BufferedImage bufferedImage) throws HistogramException {
        this.allocateStorage();
        this.computeHistogram(bufferedImage);
    }

    public Histogram(Reader reader) throws IOException {
        this.allocateStorage();
        this.read(reader);
    }

    private void accumulateFrequencies(BufferedImage bufferedImage) throws HistogramException {
        if (bufferedImage.getType() == 12 || bufferedImage.getType() == 11) {
            throw new HistogramException("invalid image type");
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        if (bufferedImage.getType() == 10) {
            int n = 0;
            while (n < bufferedImage.getHeight()) {
                int n2 = 0;
                while (n2 < bufferedImage.getWidth()) {
                    int[] nArray = this.freq[0];
                    int n3 = writableRaster.getSample(n2, n, 0);
                    nArray[n3] = nArray[n3] + 1;
                    ++n2;
                }
                ++n;
            }
        } else {
            int[] nArray = new int[3];
            int n = 0;
            while (n < bufferedImage.getHeight()) {
                int n4 = 0;
                while (n4 < bufferedImage.getWidth()) {
                    writableRaster.getPixel(n4, n, nArray);
                    int[] nArray2 = this.freq[0];
                    int n5 = nArray[0];
                    nArray2[n5] = nArray2[n5] + 1;
                    int[] nArray3 = this.freq[1];
                    int n6 = nArray[1];
                    nArray3[n6] = nArray3[n6] + 1;
                    int[] nArray4 = this.freq[2];
                    int n7 = nArray[2];
                    nArray4[n7] = nArray4[n7] + 1;
                    ++n4;
                }
                ++n;
            }
        }
    }

    private void allocateStorage() {
        this.freq = new int[3][256];
        this.cumFreq = new int[3][256];
        this.minValue = new int[3];
        this.maxValue = new int[3];
        this.minFreq = new int[3];
        this.maxFreq = new int[3];
        this.meanValue = new double[3];
    }

    public Object clone() {
        Histogram histogram = new Histogram();
        if (this.samples > 0) {
            histogram.bands = this.bands;
            histogram.samples = this.samples;
            int n = 0;
            while (n < 3) {
                System.arraycopy(this.freq[n], 0, histogram.freq[n], 0, 256);
                System.arraycopy(this.cumFreq[n], 0, histogram.cumFreq[n], 0, 256);
                ++n;
            }
            System.arraycopy(this.minFreq, 0, histogram.minFreq, 0, 3);
            System.arraycopy(this.maxFreq, 0, histogram.maxFreq, 0, 3);
            System.arraycopy(this.minValue, 0, histogram.minValue, 0, 3);
            System.arraycopy(this.maxValue, 0, histogram.maxValue, 0, 3);
            System.arraycopy(this.meanValue, 0, histogram.meanValue, 0, 3);
        }
        return histogram;
    }

    public void computeHistogram(BufferedImage bufferedImage) throws HistogramException {
        this.initialize();
        this.bands = bufferedImage.getType() == 10 ? 1 : 3;
        this.samples = bufferedImage.getWidth() * bufferedImage.getHeight();
        if (this.samples > 0) {
            this.accumulateFrequencies(bufferedImage);
            this.computeStatistics();
        }
    }

    private void computeStatistics() {
        int n = 0;
        while (n < this.bands) {
            this.cumFreq[n][0] = this.freq[n][0];
            int n2 = 1;
            while (n2 < 256) {
                this.cumFreq[n][n2] = this.cumFreq[n][n2 - 1] + this.freq[n][n2];
                ++n2;
            }
            n2 = 0;
            while (n2 < 256) {
                if (this.freq[n][n2] > 0) {
                    this.minValue[n] = n2;
                    break;
                }
                ++n2;
            }
            n2 = 255;
            while (n2 >= 0) {
                if (this.freq[n][n2] > 0) {
                    this.maxValue[n] = n2;
                    break;
                }
                --n2;
            }
            this.minFreq[n] = Integer.MAX_VALUE;
            n2 = 0;
            while (n2 < 256) {
                if (this.freq[n][n2] < this.minFreq[n]) {
                    this.minFreq[n] = this.freq[n][n2];
                } else if (this.freq[n][n2] > this.maxFreq[n]) {
                    this.maxFreq[n] = this.freq[n][n2];
                }
                int n3 = n;
                this.meanValue[n3] = this.meanValue[n3] + (double)(n2 * this.freq[n][n2]);
                ++n2;
            }
            int n4 = n++;
            this.meanValue[n4] = this.meanValue[n4] / (double)this.samples;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof Histogram) {
            Histogram histogram = (Histogram)object;
            if (this.bands != histogram.bands || this.samples != histogram.samples) {
                return false;
            }
            int n = 0;
            while (n < 256) {
                int n2 = 0;
                while (n2 < this.bands) {
                    if (this.freq[n2][n] != histogram.freq[n2][n]) {
                        return false;
                    }
                    ++n2;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public int getCumulativeFrequency(int n) throws HistogramException {
        if (this.sourceIsGrey()) {
            return this.cumFreq[0][n];
        }
        throw new HistogramException(BAND_ERROR);
    }

    public int getCumulativeFrequency(int n, int n2) {
        return this.cumFreq[n][n2];
    }

    public int getFrequency(int n) throws HistogramException {
        if (this.sourceIsGrey()) {
            return this.freq[0][n];
        }
        throw new HistogramException(BAND_ERROR);
    }

    public int getFrequency(int n, int n2) {
        return this.freq[n][n2];
    }

    public int getMaxFrequency() throws HistogramException {
        if (this.sourceIsGrey()) {
            return this.maxFreq[0];
        }
        throw new HistogramException(BAND_ERROR);
    }

    public int getMaxFrequency(int n) {
        return this.maxFreq[n];
    }

    public int getMaxValue() throws HistogramException {
        if (this.sourceIsGrey()) {
            return this.maxValue[0];
        }
        throw new HistogramException(BAND_ERROR);
    }

    public int getMaxValue(int n) {
        return this.maxValue[n];
    }

    public double getMeanValue() throws HistogramException {
        if (this.sourceIsGrey()) {
            return this.meanValue[0];
        }
        throw new HistogramException(BAND_ERROR);
    }

    public double getMeanValue(int n) {
        return this.meanValue[n];
    }

    public int getMinFrequency() throws HistogramException {
        if (this.sourceIsGrey()) {
            return this.minFreq[0];
        }
        throw new HistogramException(BAND_ERROR);
    }

    public int getMinFrequency(int n) {
        return this.minFreq[n];
    }

    public int getMinValue() throws HistogramException {
        if (this.sourceIsGrey()) {
            return this.minValue[0];
        }
        throw new HistogramException(BAND_ERROR);
    }

    public int getMinValue(int n) {
        return this.minValue[n];
    }

    public int getNumBands() {
        return this.bands;
    }

    public int getNumSamples() {
        return this.samples;
    }

    private void initialize() {
        int n;
        this.samples = 0;
        this.bands = 0;
        int n2 = 0;
        while (n2 < 3) {
            n = 0;
            while (n < 256) {
                this.cumFreq[n2][n] = 0;
                this.freq[n2][n] = 0;
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n < 3) {
            this.maxValue[n] = 0;
            this.minValue[n] = 0;
            this.maxFreq[n] = 0;
            this.minFreq[n] = 0;
            this.meanValue[n] = 0.0;
            ++n;
        }
    }

    public void read(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string = bufferedReader.readLine();
        this.initialize();
        if (string.equals("# grey histogram")) {
            this.bands = 1;
            this.samples = 0;
            int n = 0;
            while (n < 256) {
                this.freq[0][n] = Integer.parseInt(bufferedReader.readLine());
                this.samples += this.freq[0][n];
                ++n;
            }
            if (this.samples > 0) {
                this.computeStatistics();
            }
        } else if (string.equals("# RGB histogram")) {
            this.bands = 3;
            this.samples = 0;
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
            int n = 0;
            while (n < 256) {
                int n2 = 0;
                while (n2 < 3) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == -1) {
                        throw new EOFException("histogram appears to be truncated");
                    }
                    if (streamTokenizer.ttype == -2) {
                        this.freq[n2][n] = (int)streamTokenizer.nval;
                    }
                    ++n2;
                }
                this.samples += this.freq[0][n];
                ++n;
            }
            if (this.samples > 0) {
                this.computeStatistics();
            }
        } else {
            throw new IOException("invalid histogram file");
        }
    }

    public boolean sourceIsGrey() {
        return this.bands == 1;
    }

    public String toString() {
        return new String(String.valueOf(this.getClass().getName()) + ": " + this.bands + " bands, " + this.samples + " samples");
    }

    public void write(Writer writer) {
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(writer));
        if (this.sourceIsGrey()) {
            printWriter.println("# grey histogram");
            int n = 0;
            while (n < 256) {
                printWriter.println(this.freq[0][n]);
                ++n;
            }
        } else {
            printWriter.println("# RGB histograms");
            int n = 0;
            while (n < 256) {
                int n2 = 0;
                while (n2 < 3) {
                    this.writeValue(this.freq[n2][n], printWriter);
                    ++n2;
                }
                printWriter.println();
                ++n;
            }
        }
        printWriter.flush();
    }

    public void writeCumulative(Writer writer) {
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(writer));
        if (this.sourceIsGrey()) {
            printWriter.println("# grey cumulative histogram");
            int n = 0;
            while (n < 256) {
                printWriter.println(this.cumFreq[0][n]);
                ++n;
            }
        } else {
            printWriter.println("# RGB cumulative histograms");
            int n = 0;
            while (n < 256) {
                int n2 = 0;
                while (n2 < 3) {
                    this.writeValue(this.cumFreq[n2][n], printWriter);
                    ++n2;
                }
                printWriter.println();
                ++n;
            }
        }
        printWriter.flush();
    }

    private void writeValue(int n, PrintWriter printWriter) {
        if (n > 99999) {
            printWriter.print(" " + n);
        } else if (n > 9999) {
            printWriter.print("  " + n);
        } else if (n > 999) {
            printWriter.print("   " + n);
        } else if (n > 99) {
            printWriter.print("    " + n);
        } else if (n > 9) {
            printWriter.print("     " + n);
        } else {
            printWriter.print("      " + n);
        }
    }
}

