/*
 * Decompiled with CFR 0.152.
 */
package com.pearsoneduc.ip.op;

import com.pearsoneduc.ip.op.StructElement;
import com.pearsoneduc.ip.op.StructElementException;
import com.pearsoneduc.ip.util.StringTools;
import java.awt.Point;
import java.awt.image.Raster;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.StringTokenizer;

public class GreyStructElement
extends StructElement
implements Cloneable {
    public GreyStructElement(int n) throws StructElementException {
        super(3, 3);
        this.setPixels(n);
    }

    public GreyStructElement(int n, int n2, int n3) throws StructElementException {
        super(n, n2);
        this.setPixels(n3);
    }

    public GreyStructElement(int n, int n2, Point point, int n3) throws StructElementException {
        super(n, n2, point);
        this.setPixels(n3);
    }

    public GreyStructElement(Reader reader) throws IOException, StructElementException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string = bufferedReader.readLine();
        if (!string.startsWith("# grey structuring element")) {
            throw new StructElementException("no grey structuring element data available");
        }
        this.width = this.readInt(bufferedReader, "# width=");
        this.height = this.readInt(bufferedReader, "# height=");
        if (this.width < 1 || this.height < 1) {
            throw new StructElementException("invalid structuring element dimensions");
        }
        this.pixel = new int[this.height][this.width];
        this.origin = new Point(0, 0);
        this.origin.x = this.readInt(bufferedReader, "# xorigin=");
        this.origin.y = this.readInt(bufferedReader, "# yorigin=");
        int n = 0;
        while (n < this.height) {
            string = bufferedReader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() < this.width) {
                throw new StructElementException("truncated structuring element?");
            }
            int n2 = 0;
            while (n2 < this.width) {
                this.pixel[n][n2] = Integer.parseInt(stringTokenizer.nextToken());
                ++n2;
            }
            ++n;
        }
    }

    public int above(Raster raster, int n, int n2) {
        int n3 = Integer.MIN_VALUE;
        int n4 = this.height - 1;
        int n5 = n2 - this.origin.y;
        while (n4 >= 0) {
            int n6 = this.width - 1;
            int n7 = n - this.origin.x;
            while (n6 >= 0) {
                int n8 = raster.getSample(n7, n5, 0) + this.pixel[n4][n6];
                n3 = Math.max(n8, n3);
                --n6;
                ++n7;
            }
            --n4;
            ++n5;
        }
        return n3;
    }

    public int below(Raster raster, int n, int n2) {
        int n3 = Integer.MAX_VALUE;
        int n4 = 0;
        int n5 = n2 - this.origin.y;
        while (n4 < this.height) {
            int n6 = 0;
            int n7 = n - this.origin.x;
            while (n6 < this.width) {
                int n8 = raster.getSample(n7, n5, 0) - this.pixel[n4][n6];
                n3 = Math.min(n8, n3);
                ++n6;
                ++n7;
            }
            ++n4;
            ++n5;
        }
        return n3;
    }

    public Object clone() {
        try {
            GreyStructElement greyStructElement = new GreyStructElement(this.width, this.height, this.origin, 0);
            int n = 0;
            while (n < this.height) {
                int n2 = 0;
                while (n2 < this.width) {
                    greyStructElement.pixel[n][n2] = this.pixel[n][n2];
                    ++n2;
                }
                ++n;
            }
            return greyStructElement;
        }
        catch (StructElementException structElementException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        return object instanceof GreyStructElement && super.equals(object);
    }

    public GreyStructElement getRotatedVersion() {
        try {
            GreyStructElement greyStructElement = new GreyStructElement(this.width, this.height, this.origin, 0);
            int[][] nArray = new int[this.height][this.width];
            int n = 0;
            while (n < this.height) {
                int n2 = 0;
                while (n2 < this.width) {
                    nArray[n][n2] = this.pixel[this.height - n - 1][this.width - n2 - 1];
                    ++n2;
                }
                ++n;
            }
            greyStructElement.setPixels(nArray);
            return greyStructElement;
        }
        catch (StructElementException structElementException) {
            return null;
        }
    }

    public void setPixel(int n, int n2, int n3) {
        this.pixel[n2][n] = n3;
    }

    public void setPixels(int n) {
        int n2 = 0;
        while (n2 < this.height) {
            int n3 = 0;
            while (n3 < this.width) {
                this.pixel[n2][n3] = n;
                ++n3;
            }
            ++n2;
        }
    }

    public void setPixels(String string) throws StructElementException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() != this.width * this.height) {
            throw new StructElementException("invalid string of values");
        }
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                this.pixel[n][n2] = Integer.parseInt(stringTokenizer.nextToken());
                ++n2;
            }
            ++n;
        }
    }

    public void setPixels(int[] nArray) throws StructElementException {
        if (nArray.length < this.width * this.height) {
            throw new StructElementException("fewer values than structuring element pixels");
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.height) {
            int n3 = 0;
            while (n3 < this.width) {
                this.pixel[n2][n3] = nArray[n];
                ++n3;
                ++n;
            }
            ++n2;
        }
    }

    public void setPixels(int[][] nArray) throws StructElementException {
        if (nArray.length < this.height || nArray[0].length < this.width) {
            throw new StructElementException("fewer values than structuring element pixels");
        }
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                this.pixel[n][n2] = nArray[n][n2];
                ++n2;
            }
            ++n;
        }
    }

    public void write(Writer writer) throws IOException {
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(writer));
        printWriter.println("# grey structuring element");
        printWriter.println("# width=" + this.width);
        printWriter.println("# height=" + this.height);
        printWriter.println("# xorigin=" + this.origin.x);
        printWriter.println("# yorigin=" + this.origin.y);
        if (printWriter.checkError()) {
            throw new IOException("error writing SE header");
        }
        this.writePixels(writer);
    }

    public void writePixels(Writer writer) {
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(writer));
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                printWriter.print(StringTools.rightJustify(this.pixel[n][n2], 5));
                ++n2;
            }
            printWriter.println();
            ++n;
        }
        printWriter.flush();
    }
}

