/*
 * Decompiled with CFR 0.152.
 */
package com.pearsoneduc.ip.op;

import com.pearsoneduc.ip.op.MeanKernel;
import com.pearsoneduc.ip.op.NeighbourhoodOp;
import com.pearsoneduc.ip.op.SeparableGaussianKernel;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ConvolveOp;
import java.awt.image.DataBufferByte;
import java.awt.image.ImagingOpException;
import java.awt.image.Kernel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class ConvolutionOp
extends NeighbourhoodOp {
    public static final int SINGLE_PASS = 1;
    public static final int SEPARABLE = 2;
    public static final int NO_RESCALING = 1;
    public static final int RESCALE_MAX_ONLY = 2;
    public static final int RESCALE_MIN_AND_MAX = 3;
    private Kernel kernel;
    private int calculation;
    private int rescaleStrategy;

    public ConvolutionOp(Kernel kernel) {
        this(kernel, 1, 1, 1);
    }

    public ConvolutionOp(Kernel kernel, int n, int n2, int n3) {
        super(kernel.getWidth(), kernel.getHeight(), n);
        this.kernel = kernel;
        this.calculation = n2;
        this.rescaleStrategy = n3;
    }

    public static BufferedImage blur(BufferedImage bufferedImage, int n, int n2) {
        return ConvolutionOp.blur(bufferedImage, n, n2, 1);
    }

    public static BufferedImage blur(BufferedImage bufferedImage, int n, int n2, int n3) {
        MeanKernel meanKernel = new MeanKernel(n, n2);
        BufferedImageOp bufferedImageOp = n3 == 4 || n3 == 3 ? new ConvolutionOp(meanKernel, n3, 1, 1) : (n3 == 2 ? new ConvolveOp(meanKernel, 1, null) : new ConvolveOp(meanKernel, 0, null));
        return bufferedImageOp.filter(bufferedImage, null);
    }

    protected void convertToBytes(float[] fArray, byte[] byArray) {
        if (this.rescaleStrategy == 1) {
            int n = 0;
            while (n < fArray.length) {
                int n2 = Math.round(fArray[n]);
                byArray[n] = n2 < 0 ? 0 : (n2 > 255 ? -1 : (byte)n2);
                ++n;
            }
        } else {
            float f = fArray[0];
            float f2 = fArray[0];
            int n = 1;
            while (n < fArray.length) {
                if (fArray[n] < f) {
                    f = fArray[n];
                } else if (fArray[n] > f2) {
                    f2 = fArray[n];
                }
                ++n;
            }
            if (this.rescaleStrategy == 3) {
                float f3 = 255.0f / (f2 - f);
                int n3 = 0;
                while (n3 < fArray.length) {
                    byArray[n3] = (byte)Math.round(f3 * (fArray[n3] - f));
                    ++n3;
                }
            } else if (f < 0.0f && f2 > 0.0f) {
                float f4 = Math.max(Math.abs(f), f2);
                float f5 = 127.5f / f4;
                int n4 = 0;
                while (n4 < fArray.length) {
                    byArray[n4] = (byte)Math.round(f5 * (fArray[n4] + f4));
                    ++n4;
                }
            } else {
                float f6 = 255.0f / f2;
                int n5 = 0;
                while (n5 < fArray.length) {
                    byArray[n5] = (byte)Math.round(f6 * fArray[n5]);
                    ++n5;
                }
            }
        }
    }

    public float[] convolve(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        WritableRaster writableRaster = bufferedImage.getRaster();
        float[] fArray = new float[n * n2];
        float[] fArray2 = this.kernel.getKernelData(null);
        int n3 = this.width / 2;
        int n4 = this.height / 2;
        switch (this.borderStrategy) {
            case 3: {
                int n5 = 0;
                while (n5 < n2) {
                    int n6 = 0;
                    while (n6 < n) {
                        float f = 0.0f;
                        int n7 = 0;
                        int n8 = -n4;
                        while (n8 <= n4) {
                            int n9 = -n3;
                            while (n9 <= n3) {
                                f += fArray2[n7] * (float)writableRaster.getSample(NeighbourhoodOp.refIndex(n6 - n9, n), NeighbourhoodOp.refIndex(n5 - n8, n2), 0);
                                ++n9;
                                ++n7;
                            }
                            ++n8;
                        }
                        fArray[n5 * n + n6] = f;
                        ++n6;
                    }
                    ++n5;
                }
                break;
            }
            case 4: {
                int n10 = 0;
                while (n10 < n2) {
                    int n11 = 0;
                    while (n11 < n) {
                        float f = 0.0f;
                        int n12 = 0;
                        int n13 = -n4;
                        while (n13 <= n4) {
                            int n14 = -n3;
                            while (n14 <= n3) {
                                f += fArray2[n12] * (float)writableRaster.getSample(NeighbourhoodOp.circIndex(n11 - n14, n), NeighbourhoodOp.circIndex(n10 - n13, n2), 0);
                                ++n14;
                                ++n12;
                            }
                            ++n13;
                        }
                        fArray[n10 * n + n11] = f;
                        ++n11;
                    }
                    ++n10;
                }
                break;
            }
            case 2: {
                this.copyBorders((Raster)writableRaster, fArray);
            }
            default: {
                int n15 = n4;
                while (n15 < n2 - n4) {
                    int n16 = n3;
                    while (n16 < n - n3) {
                        float f = 0.0f;
                        int n17 = 0;
                        int n18 = -n4;
                        while (n18 <= n4) {
                            int n19 = -n3;
                            while (n19 <= n3) {
                                f += fArray2[n17] * (float)writableRaster.getSample(n16 - n19, n15 - n18, 0);
                                ++n19;
                                ++n17;
                            }
                            ++n18;
                        }
                        fArray[n15 * n + n16] = f;
                        ++n16;
                    }
                    ++n15;
                }
                break block0;
            }
        }
        return fArray;
    }

    protected void copyBorders(Raster raster, float[] fArray) {
        int n;
        int n2;
        int n3 = raster.getWidth();
        int n4 = raster.getHeight();
        int n5 = this.width / 2;
        int n6 = this.calculation == 2 ? n5 : this.height / 2;
        int n7 = 0;
        while (n7 < n3) {
            n2 = 0;
            while (n2 < n6) {
                fArray[n2 * n3 + n7] = raster.getSample(n7, n2, 0);
                ++n2;
            }
            n = n4 - n6;
            while (n < n4) {
                fArray[n * n3 + n7] = raster.getSample(n7, n, 0);
                ++n;
            }
            ++n7;
        }
        n2 = 0;
        while (n2 < n4) {
            n = 0;
            while (n < n5) {
                fArray[n2 * n3 + n] = raster.getSample(n, n2, 0);
                ++n;
            }
            int n8 = n3 - n5;
            while (n8 < n3) {
                fArray[n2 * n3 + n8] = raster.getSample(n8, n2, 0);
                ++n8;
            }
            ++n2;
        }
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.checkImage(bufferedImage);
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        }
        float[] fArray = this.calculation == 2 ? this.separableConvolve(bufferedImage) : this.convolve(bufferedImage);
        DataBufferByte dataBufferByte = (DataBufferByte)bufferedImage2.getRaster().getDataBuffer();
        this.convertToBytes(fArray, dataBufferByte.getData());
        return bufferedImage2;
    }

    public static BufferedImage gaussianBlur(BufferedImage bufferedImage, float f) {
        return ConvolutionOp.gaussianBlur(bufferedImage, f, 1);
    }

    public static BufferedImage gaussianBlur(BufferedImage bufferedImage, float f, int n) {
        SeparableGaussianKernel separableGaussianKernel = new SeparableGaussianKernel(f);
        ConvolutionOp convolutionOp = new ConvolutionOp(separableGaussianKernel, n, 2, 1);
        return convolutionOp.filter(bufferedImage, null);
    }

    public float[] separableConvolve(BufferedImage bufferedImage) {
        if (this.height != 1) {
            throw new ImagingOpException("1D kernel required for separable convolution");
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        WritableRaster writableRaster = bufferedImage.getRaster();
        float[] fArray = new float[n * n2];
        float[] fArray2 = new float[n * n2];
        float[] fArray3 = this.kernel.getKernelData(null);
        int n3 = this.width / 2;
        switch (this.borderStrategy) {
            case 3: {
                int n4;
                float f;
                int n5;
                int n6 = 0;
                while (n6 < n2) {
                    n5 = 0;
                    while (n5 < n) {
                        f = 0.0f;
                        n4 = -n3;
                        while (n4 <= n3) {
                            f += fArray3[n4 + n3] * (float)writableRaster.getSample(NeighbourhoodOp.refIndex(n5 - n4, n), n6, 0);
                            ++n4;
                        }
                        fArray[n6 * n + n5] = f;
                        ++n5;
                    }
                    ++n6;
                }
                n6 = 0;
                while (n6 < n2) {
                    n5 = 0;
                    while (n5 < n) {
                        f = 0.0f;
                        n4 = -n3;
                        while (n4 <= n3) {
                            f += fArray3[n4 + n3] * fArray[n * NeighbourhoodOp.refIndex(n6 - n4, n2) + n5];
                            ++n4;
                        }
                        fArray2[n6 * n + n5] = f;
                        ++n5;
                    }
                    ++n6;
                }
                break;
            }
            case 4: {
                int n7;
                float f;
                int n8;
                int n9 = 0;
                while (n9 < n2) {
                    n8 = 0;
                    while (n8 < n) {
                        f = 0.0f;
                        n7 = -n3;
                        while (n7 <= n3) {
                            f += fArray3[n7 + n3] * (float)writableRaster.getSample(NeighbourhoodOp.circIndex(n8 - n7, n), n9, 0);
                            ++n7;
                        }
                        fArray[n9 * n + n8] = f;
                        ++n8;
                    }
                    ++n9;
                }
                n9 = 0;
                while (n9 < n2) {
                    n8 = 0;
                    while (n8 < n) {
                        f = 0.0f;
                        n7 = -n3;
                        while (n7 <= n3) {
                            f += fArray3[n7 + n3] * fArray[n * NeighbourhoodOp.circIndex(n9 - n7, n2) + n8];
                            ++n7;
                        }
                        fArray2[n9 * n + n8] = f;
                        ++n8;
                    }
                    ++n9;
                }
                break;
            }
            case 2: {
                this.copyBorders((Raster)writableRaster, fArray2);
            }
            default: {
                int n10;
                float f;
                int n11;
                this.copyBorders((Raster)writableRaster, fArray);
                int n12 = n3;
                while (n12 < n2 - n3) {
                    n11 = n3;
                    while (n11 < n - n3) {
                        f = 0.0f;
                        n10 = -n3;
                        while (n10 <= n3) {
                            f += fArray3[n10 + n3] * (float)writableRaster.getSample(n11 - n10, n12, 0);
                            ++n10;
                        }
                        fArray[n12 * n + n11] = f;
                        ++n11;
                    }
                    ++n12;
                }
                n12 = n3;
                while (n12 < n2 - n3) {
                    n11 = n3;
                    while (n11 < n - n3) {
                        f = 0.0f;
                        n10 = -n3;
                        while (n10 <= n3) {
                            f += fArray3[n10 + n3] * fArray[(n12 - n10) * n + n11];
                            ++n10;
                        }
                        fArray2[n12 * n + n11] = f;
                        ++n11;
                    }
                    ++n12;
                }
                break block0;
            }
        }
        return fArray2;
    }
}

