/*
 * Decompiled with CFR 0.152.
 */
package com.pearsoneduc.ip.op;

import com.pearsoneduc.ip.op.ConvolutionOp;
import com.pearsoneduc.ip.op.SeparableGaussianKernel;
import com.pearsoneduc.ip.op.StandardGreyOp;
import java.awt.image.BufferedImage;
import java.awt.image.ImagingOpException;
import java.awt.image.Kernel;
import java.awt.image.WritableRaster;

public class CannyEdgeOp
extends StandardGreyOp {
    public static final int SQRT_MAGNITUDES = 1;
    public static final int ABS_MAGNITUDES = 2;
    private static final double[] SECTOR_ANGLE = new double[]{0.39269908169872414, 1.1780972450961724, 1.9634954084936207, 2.748893571891069};
    private float filterSize;
    private int lowThreshold = -1;
    private int highThreshold = -1;
    private int magCalcMethod = 1;
    private Kernel kernel;
    private int width;
    private int height;
    private WritableRaster magnitude;
    private WritableRaster orientation;

    public CannyEdgeOp(float f) {
        this.setFilterSize(f);
    }

    public CannyEdgeOp(float f, int n, int n2) {
        this(f);
        this.setThresholds(n, n2);
    }

    public CannyEdgeOp(float f, int n, int n2, int n3) {
        this(f, n, n2);
        this.magCalcMethod = n3;
    }

    protected void applyHighThreshold(BufferedImage bufferedImage) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n = 1;
        while (n < this.height - 1) {
            int n2 = 1;
            while (n2 < this.width - 1) {
                if (this.magnitude.getSample(n2, n, 0) >= this.highThreshold) {
                    writableRaster.setSample(n2, n, 0, 255);
                }
                ++n2;
            }
            ++n;
        }
    }

    protected void computeGradient(BufferedImage bufferedImage) {
        ConvolutionOp convolutionOp = new ConvolutionOp(this.kernel, 3, 2, 1);
        float[] fArray = convolutionOp.separableConvolve(bufferedImage);
        float[] fArray2 = new float[this.width * this.height];
        float f = 0.0f;
        int n = 1;
        while (n < this.height - 1) {
            int n2 = 1;
            while (n2 < this.width - 1) {
                float f2 = this.xGradient(fArray, n2, n);
                float f3 = this.yGradient(fArray, n2, n);
                float f4 = this.magCalcMethod == 2 ? Math.abs(f2) + Math.abs(f3) : (float)Math.sqrt(f2 * f2 + f3 * f3);
                if (f4 > f) {
                    f = f4;
                }
                fArray2[n * this.width + n2] = f4;
                this.orientation.setSample(n2, n, 0, this.sector(f2, f3));
                ++n2;
            }
            ++n;
        }
        float f5 = 255.0f / f;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.height) {
            int n5 = 0;
            while (n5 < this.width) {
                this.magnitude.setSample(n5, n4, 0, Math.round(f5 * fArray2[n3]));
                ++n5;
                ++n3;
            }
            ++n4;
        }
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.checkImage(bufferedImage);
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        }
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
        WritableRaster writableRaster = bufferedImage.getRaster();
        this.magnitude = writableRaster.createCompatibleWritableRaster();
        this.orientation = writableRaster.createCompatibleWritableRaster();
        this.computeGradient(bufferedImage);
        this.performNonMaximalSuppression();
        if (this.lowThreshold > 0 && this.highThreshold > 0) {
            if (this.lowThreshold == this.highThreshold) {
                this.applyHighThreshold(bufferedImage2);
            } else {
                this.performHysteresisThresholding(bufferedImage2);
            }
        }
        return bufferedImage2;
    }

    public float getFilterSize() {
        return this.filterSize;
    }

    public BufferedImage getGradientMagnitudeImage() {
        if (this.magnitude == null) {
            throw new ImagingOpException("no gradient magnitude data available");
        }
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 10);
        bufferedImage.setData(this.magnitude);
        return bufferedImage;
    }

    public BufferedImage getGradientOrientationImage() {
        if (this.orientation == null) {
            throw new ImagingOpException("no gradient orientation data available");
        }
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 10);
        bufferedImage.setData(this.orientation);
        return bufferedImage;
    }

    public int getHighThreshold() {
        return this.highThreshold;
    }

    public int getLowThreshold() {
        return this.lowThreshold;
    }

    public int getMagnitudeCalculationMethod() {
        return this.magCalcMethod;
    }

    protected void performHysteresisThresholding(BufferedImage bufferedImage) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n = 1;
        while (n < this.height - 1) {
            int n2 = 1;
            while (n2 < this.width - 1) {
                if (this.magnitude.getSample(n2, n, 0) >= this.highThreshold) {
                    this.trace(n2, n, writableRaster);
                }
                ++n2;
            }
            ++n;
        }
    }

    protected void performNonMaximalSuppression() {
        WritableRaster writableRaster = this.magnitude.createCompatibleWritableRaster();
        int n = 1;
        while (n < this.height - 1) {
            int n2 = 1;
            while (n2 < this.width - 1) {
                int n3 = this.magnitude.getSample(n2, n, 0);
                int n4 = this.orientation.getSample(n2, n, 0);
                if (n4 == 1 && (n3 < this.magnitude.getSample(n2 - 1, n, 0) || n3 < this.magnitude.getSample(n2 + 1, n, 0)) || n4 == 2 && (n3 < this.magnitude.getSample(n2 - 1, n + 1, 0) || n3 < this.magnitude.getSample(n2 + 1, n - 1, 0)) || n4 == 3 && (n3 < this.magnitude.getSample(n2, n - 1, 0) || n3 < this.magnitude.getSample(n2, n + 1, 0)) || n4 == 4 && (n3 < this.magnitude.getSample(n2 - 1, n - 1, 0) || n3 < this.magnitude.getSample(n2 + 1, n + 1, 0))) {
                    writableRaster.setSample(n2, n, 0, 0);
                } else {
                    writableRaster.setSample(n2, n, 0, n3);
                }
                ++n2;
            }
            ++n;
        }
        this.magnitude = writableRaster;
    }

    private int sector(float f, float f2) {
        double d = Math.abs(Math.atan2(f2, f));
        int n = 0;
        while (n < 4) {
            if (d < SECTOR_ANGLE[n]) {
                return n + 1;
            }
            ++n;
        }
        return 1;
    }

    private void setFilterSize(float f) {
        if (f <= 0.0f) {
            throw new ImagingOpException("filter size must be greater than zero");
        }
        this.filterSize = f;
        this.kernel = new SeparableGaussianKernel(f);
    }

    private void setThresholds(int n, int n2) {
        if (n < 1 || n2 > 255 || n > n2) {
            throw new ImagingOpException("invalid thresholds");
        }
        this.lowThreshold = n;
        this.highThreshold = n2;
    }

    protected boolean trace(int n, int n2, WritableRaster writableRaster) {
        if (writableRaster.getSample(n, n2, 0) == 0) {
            writableRaster.setSample(n, n2, 0, 255);
            int n3 = -1;
            while (n3 <= 1) {
                int n4 = -1;
                while (n4 <= 1) {
                    if ((n4 != 0 || n3 != 0) && this.magnitude.getSample(n + n4, n2 + n3, 0) >= this.lowThreshold && this.trace(n + n4, n2 + n3, writableRaster)) {
                        return true;
                    }
                    ++n4;
                }
                ++n3;
            }
        }
        return false;
    }

    private final float xGradient(float[] fArray, int n, int n2) {
        return fArray[n2 * this.width + n + 1] - fArray[n2 * this.width + n - 1];
    }

    private final float yGradient(float[] fArray, int n, int n2) {
        return fArray[(n2 + 1) * this.width + n] - fArray[(n2 - 1) * this.width + n];
    }
}

