/*
 * Decompiled with CFR 0.152.
 */
package com.pearsoneduc.ip.op;

import com.pearsoneduc.ip.op.FFTException;
import com.pearsoneduc.ip.op.ImageFFT;
import com.pearsoneduc.ip.op.StandardGreyOp;
import java.awt.image.BufferedImage;
import java.awt.image.ImagingOpException;

public class ButterworthLowPassOp
extends StandardGreyOp {
    protected int order;
    protected double radius;

    public ButterworthLowPassOp(double d) {
        this(1, d);
    }

    public ButterworthLowPassOp(int n, double d) {
        if (n < 1 || d < 0.0) {
            throw new ImagingOpException("invalid filter parameters");
        }
        this.order = n;
        this.radius = d;
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.checkImage(bufferedImage);
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        }
        try {
            ImageFFT imageFFT = new ImageFFT(bufferedImage);
            imageFFT.transform();
            imageFFT.butterworthLowPassFilter(this.order, this.radius);
            imageFFT.transform();
            imageFFT.toImage(bufferedImage2);
        }
        catch (FFTException fFTException) {
            throw new ImagingOpException("cannot filter image");
        }
        return bufferedImage2;
    }

    public int getOrder() {
        return this.order;
    }

    public double getRadius() {
        return this.radius;
    }
}

