/*
 * Decompiled with CFR 0.152.
 */
package com.pearsoneduc.ip.op;

import com.pearsoneduc.ip.op.StructElement;
import com.pearsoneduc.ip.op.StructElementException;
import com.pearsoneduc.ip.op.StructElementTypes;
import java.awt.Point;
import java.awt.image.Raster;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;

public class BinaryStructElement
extends StructElement
implements Cloneable,
StructElementTypes {
    public BinaryStructElement() throws StructElementException {
        super(3, 3);
        this.setPixels();
    }

    public BinaryStructElement(int n) throws StructElementException {
        switch (n) {
            case 1: {
                this.height = 3;
                this.width = 3;
                this.origin = new Point(1, 1);
                this.pixel = new int[3][3];
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                this.height = 5;
                this.width = 5;
                this.origin = new Point(2, 2);
                this.pixel = new int[5][5];
                break;
            }
            case 4: 
            case 6: {
                this.height = 7;
                this.width = 7;
                this.origin = new Point(3, 3);
                this.pixel = new int[7][7];
                break;
            }
            default: {
                throw new StructElementException("invalid structuring element type");
            }
        }
        switch (n) {
            case 1: {
                this.setPixels("010111010");
                break;
            }
            case 2: {
                this.setPixels("0010000100111110010000100");
                break;
            }
            case 3: {
                this.setPixels("0010001110111110111000100");
                break;
            }
            case 4: {
                this.setPixels("0001000001110001111101111111011111000111000001000");
                break;
            }
            case 5: {
                this.setPixels("0111011111111111111101110");
                break;
            }
            case 6: {
                this.setPixels("0011100011111011111111111111111111101111100011100");
                break;
            }
        }
    }

    public BinaryStructElement(int n, int n2) throws StructElementException {
        super(n, n2);
        this.setPixels();
    }

    public BinaryStructElement(int n, int n2, Point point) throws StructElementException {
        super(n, n2, point);
        this.setPixels();
    }

    public BinaryStructElement(Reader reader) throws IOException, StructElementException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string = bufferedReader.readLine();
        if (!string.startsWith("# binary structuring element")) {
            throw new StructElementException("no binary structuring element data available");
        }
        this.width = this.readInt(bufferedReader, "# width=");
        this.height = this.readInt(bufferedReader, "# height=");
        if (this.width < 1 || this.height < 1) {
            throw new StructElementException("invalid structuring element dimensions");
        }
        this.pixel = new int[this.height][this.width];
        this.origin = new Point(0, 0);
        this.origin.x = this.readInt(bufferedReader, "# xorigin=");
        this.origin.y = this.readInt(bufferedReader, "# yorigin=");
        int n = 0;
        while (n < this.height) {
            string = bufferedReader.readLine();
            if (string.length() < this.width) {
                throw new StructElementException("truncated structuring element?");
            }
            int n2 = 0;
            while (n2 < this.width) {
                int n3 = Character.digit(string.charAt(n2), 2);
                if (n3 < 0 || n3 > 1) {
                    throw new StructElementException("invalid structuring element value");
                }
                this.pixel[n][n2] = n3;
                ++n2;
            }
            ++n;
        }
    }

    public void clearPixel(int n, int n2) {
        this.pixel[n2][n] = 0;
    }

    public Object clone() {
        try {
            BinaryStructElement binaryStructElement = new BinaryStructElement(this.width, this.height, this.origin);
            int n = 0;
            while (n < this.height) {
                int n2 = 0;
                while (n2 < this.width) {
                    binaryStructElement.pixel[n][n2] = this.pixel[n][n2];
                    ++n2;
                }
                ++n;
            }
            return binaryStructElement;
        }
        catch (StructElementException structElementException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        return object instanceof BinaryStructElement && super.equals(object);
    }

    public boolean fits(Raster raster, int n, int n2) {
        int n3 = 0;
        int n4 = n2 - this.origin.y;
        while (n3 < this.height) {
            int n5 = 0;
            int n6 = n - this.origin.x;
            while (n5 < this.width) {
                if (this.pixel[n3][n5] == 1 && raster.getSample(n6, n4, 0) == 0) {
                    return false;
                }
                ++n5;
                ++n6;
            }
            ++n3;
            ++n4;
        }
        return true;
    }

    public boolean fitsComplement(Raster raster, int n, int n2) {
        int n3 = 0;
        int n4 = n2 - this.origin.y;
        while (n3 < this.height) {
            int n5 = 0;
            int n6 = n - this.origin.x;
            while (n5 < this.width) {
                if (this.pixel[n3][n5] == 1 && raster.getSample(n6, n4, 0) != 0) {
                    return false;
                }
                ++n5;
                ++n6;
            }
            ++n3;
            ++n4;
        }
        return true;
    }

    public BinaryStructElement getRotatedVersion() {
        try {
            BinaryStructElement binaryStructElement = new BinaryStructElement(this.width, this.height, this.origin);
            int[][] nArray = new int[this.height][this.width];
            int n = 0;
            while (n < this.height) {
                int n2 = 0;
                while (n2 < this.width) {
                    nArray[n][n2] = this.pixel[this.height - n - 1][this.width - n2 - 1];
                    ++n2;
                }
                ++n;
            }
            binaryStructElement.setPixels(nArray);
            return binaryStructElement;
        }
        catch (StructElementException structElementException) {
            return null;
        }
    }

    public boolean hits(Raster raster, int n, int n2) {
        int n3 = 0;
        int n4 = n2 - this.origin.y;
        while (n3 < this.height) {
            int n5 = 0;
            int n6 = n - this.origin.x;
            while (n5 < this.width) {
                if (this.pixel[n3][n5] == 1 && raster.getSample(n6, n4, 0) != 0) {
                    return true;
                }
                ++n5;
                ++n6;
            }
            ++n3;
            ++n4;
        }
        return false;
    }

    public void setPixel(int n, int n2) {
        this.pixel[n2][n] = 1;
    }

    public void setPixels() {
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                this.pixel[n][n2] = 1;
                ++n2;
            }
            ++n;
        }
    }

    public void setPixels(String string) throws StructElementException {
        if (string.length() != this.width * this.height) {
            throw new StructElementException("invalid string of values");
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.height) {
            int n3 = 0;
            while (n3 < this.width) {
                int n4;
                if ((n4 = Character.digit(string.charAt(n++), 2)) < 0 || n4 > 1) {
                    throw new StructElementException("invalid structuring element value");
                }
                this.pixel[n2][n3] = n4;
                ++n3;
            }
            ++n2;
        }
    }

    public void setPixels(int[] nArray) throws StructElementException {
        if (nArray.length < this.width * this.height) {
            throw new StructElementException("fewer values than structuring element pixels");
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.height) {
            int n3 = 0;
            while (n3 < this.width) {
                if (nArray[n] < 0 || nArray[n] > 1) {
                    throw new StructElementException("invalid structuring element value");
                }
                this.pixel[n2][n3] = nArray[n];
                ++n3;
                ++n;
            }
            ++n2;
        }
    }

    public void setPixels(int[][] nArray) throws StructElementException {
        if (nArray.length < this.height || nArray[0].length < this.width) {
            throw new StructElementException("fewer values than structuring element pixels");
        }
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                if (nArray[n][n2] < 0 || nArray[n][n2] > 1) {
                    throw new StructElementException("invalid structuring element value");
                }
                this.pixel[n][n2] = nArray[n][n2];
                ++n2;
            }
            ++n;
        }
    }

    public void write(Writer writer) throws IOException {
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(writer));
        printWriter.println("# binary structuring element");
        printWriter.println("# width=" + this.width);
        printWriter.println("# height=" + this.height);
        printWriter.println("# xorigin=" + this.origin.x);
        printWriter.println("# yorigin=" + this.origin.y);
        if (printWriter.checkError()) {
            throw new IOException("error writing SE header");
        }
        this.writePixels(writer);
    }

    public void writePixels(Writer writer) {
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(writer));
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                printWriter.print(this.pixel[n][n2]);
                ++n2;
            }
            printWriter.println();
            ++n;
        }
        printWriter.flush();
    }
}

