/*
 * Decompiled with CFR 0.152.
 */
package com.pearsoneduc.ip.io;

import com.pearsoneduc.ip.io.ImageEncoder;
import com.pearsoneduc.ip.io.SIFConstants;
import com.pearsoneduc.ip.io.SIFEncoderException;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;

public class SIFEncoder
implements ImageEncoder,
SIFConstants {
    private DataOutputStream output;
    private boolean compression = true;

    public SIFEncoder() {
        this(System.out);
    }

    public SIFEncoder(OutputStream outputStream) {
        this.output = new DataOutputStream(outputStream);
    }

    public SIFEncoder(String string) throws FileNotFoundException {
        this(new FileOutputStream(string));
    }

    public boolean compressionEnabled() {
        return this.compression;
    }

    public void disableCompression() {
        this.compression = false;
    }

    public void enableCompression() {
        this.compression = true;
    }

    public void encode(BufferedImage bufferedImage) throws IOException, SIFEncoderException {
        this.writeHeader(bufferedImage);
        if (bufferedImage.getType() == 10 || bufferedImage.getType() == 5) {
            DataBufferByte dataBufferByte = (DataBufferByte)bufferedImage.getRaster().getDataBuffer();
            byte[] byArray = dataBufferByte.getData();
            if (this.compression) {
                DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(this.output);
                deflaterOutputStream.write(byArray, 0, byArray.length);
                deflaterOutputStream.finish();
            } else {
                this.output.write(byArray);
                this.output.flush();
            }
        } else {
            WritableRaster writableRaster = bufferedImage.getRaster();
            if (this.compression) {
                DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(this.output);
                int n = 0;
                while (n < bufferedImage.getHeight()) {
                    int n2 = 0;
                    while (n2 < bufferedImage.getWidth()) {
                        int n3 = 2;
                        while (n3 >= 0) {
                            deflaterOutputStream.write(writableRaster.getSample(n2, n, n3));
                            --n3;
                        }
                        ++n2;
                    }
                    ++n;
                }
                deflaterOutputStream.finish();
            } else {
                int n = 0;
                while (n < bufferedImage.getHeight()) {
                    int n4 = 0;
                    while (n4 < bufferedImage.getWidth()) {
                        int n5 = 2;
                        while (n5 >= 0) {
                            this.output.write(writableRaster.getSample(n4, n, n5));
                            --n5;
                        }
                        ++n4;
                    }
                    ++n;
                }
                this.output.flush();
            }
        }
    }

    private void writeHeader(BufferedImage bufferedImage) throws IOException, SIFEncoderException {
        if (bufferedImage.getType() == 12 || bufferedImage.getType() == 11 || bufferedImage.getType() == 9 || bufferedImage.getType() == 8 || bufferedImage.getType() == 13) {
            throw new SIFEncoderException("unsupported image type");
        }
        if (bufferedImage.getType() == 10) {
            if (this.compression) {
                this.output.write("gIMG".getBytes());
            } else {
                this.output.write("GIMG".getBytes());
            }
        } else if (this.compression) {
            this.output.write("cIMG".getBytes());
        } else {
            this.output.write("CIMG".getBytes());
        }
        this.output.writeInt(bufferedImage.getWidth());
        this.output.writeInt(bufferedImage.getHeight());
        this.output.flush();
    }
}

