/*
 * Decompiled with CFR 0.152.
 */
package com.pearsoneduc.ip.io;

import com.pearsoneduc.ip.io.ImageDecoder;
import com.pearsoneduc.ip.io.SIFConstants;
import com.pearsoneduc.ip.io.SIFDecoderException;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;

public class SIFDecoder
implements ImageDecoder,
SIFConstants {
    private DataInputStream input;
    private byte[] signature;
    private boolean compression;
    private int type;
    private int width;
    private int height;

    public SIFDecoder() throws IOException, SIFDecoderException {
        this(System.in);
    }

    public SIFDecoder(InputStream inputStream) throws IOException, SIFDecoderException {
        this.input = new DataInputStream(inputStream);
        this.readHeader();
    }

    public SIFDecoder(String string) throws IOException, SIFDecoderException {
        this(new FileInputStream(string));
    }

    public BufferedImage decodeAsBufferedImage() throws IOException {
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, this.type);
        DataBufferByte dataBufferByte = (DataBufferByte)bufferedImage.getRaster().getDataBuffer();
        byte[] byArray = dataBufferByte.getData();
        if (this.compression) {
            int n;
            InflaterInputStream inflaterInputStream = new InflaterInputStream(this.input);
            int n2 = 0;
            while ((n = inflaterInputStream.read()) != -1) {
                byArray[n2++] = (byte)n;
            }
        } else {
            this.input.readFully(byArray);
        }
        return bufferedImage;
    }

    public int getHeight() {
        return this.height;
    }

    public int getNumBands() {
        if (this.type == 5) {
            return 3;
        }
        if (this.type == 10) {
            return 1;
        }
        return 0;
    }

    public int getNumPixels() {
        return this.width * this.height;
    }

    public String getSignatureString() {
        return new String(this.signature);
    }

    public int getType() {
        return this.type;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isCompressed() {
        return this.compression;
    }

    public boolean isGrey() {
        return this.type == 10;
    }

    public boolean isRGB() {
        return this.type == 5;
    }

    private void readHeader() throws IOException, SIFDecoderException {
        this.signature = new byte[4];
        this.input.readFully(this.signature);
        String string = this.getSignatureString();
        if (string.equals("GIMG") || string.equals("gIMG")) {
            this.type = 10;
        } else if (string.equals("CIMG") || string.equals("cIMG")) {
            this.type = 5;
        } else {
            throw new SIFDecoderException("invalid data signature");
        }
        this.compression = Character.isLowerCase(string.charAt(0));
        this.width = this.input.readInt();
        this.height = this.input.readInt();
    }
}

