/*
 * Decompiled with CFR 0.152.
 */
package com.pearsoneduc.ip.io;

import com.pearsoneduc.ip.io.ImageEncoder;
import com.pearsoneduc.ip.io.PPMConstants;
import com.pearsoneduc.ip.io.PPMEncoderException;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;

public class PPMEncoder
implements ImageEncoder,
PPMConstants {
    private static final int MAX_USHORT_VALUE = 65535;
    private static final int MAX_BITS_PER_LINE = 70;
    private static final int MAX_BYTES_PER_LINE = 17;
    private static final int MAX_SHORTS_PER_LINE = 11;
    private static final int MAX_RGB_PER_LINE = 5;
    private PrintWriter writer;
    private int type = 0;
    private int maxValue = 255;
    private boolean comments = true;
    private int one = 0;

    public PPMEncoder() {
        this(System.out);
    }

    public PPMEncoder(OutputStream outputStream) {
        this.writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream)));
    }

    public PPMEncoder(String string) throws IOException {
        this.writer = new PrintWriter(new BufferedWriter(new FileWriter(string)));
    }

    public boolean bitmapInversionEnabled() {
        return this.one == 0;
    }

    private void checkImageType(BufferedImage bufferedImage) {
        this.type = bufferedImage.getType() == 12 ? 1 : (bufferedImage.getType() == 10 || bufferedImage.getType() == 11 ? 2 : 3);
        if (bufferedImage.getType() == 11) {
            this.maxValue = 65535;
        }
    }

    public boolean commentsEnabled() {
        return this.comments;
    }

    public void disableBitmapInversion() {
        this.one = 1;
    }

    public void disableComments() {
        this.comments = false;
    }

    public void enableBitmapInversion() {
        this.one = 0;
    }

    public void enableComments() {
        this.comments = true;
    }

    public void encode(BufferedImage bufferedImage) throws PPMEncoderException {
        this.checkImageType(bufferedImage);
        this.writeHeader(bufferedImage);
        if (this.type == 1) {
            this.writePBM(bufferedImage);
        } else if (this.type == 2) {
            this.writePGM(bufferedImage);
        } else {
            this.writePPM(bufferedImage);
        }
    }

    private void writeAsByte(int n) {
        if (n < 10) {
            this.writer.print("   " + n);
        } else if (n < 100) {
            this.writer.print("  " + n);
        } else {
            this.writer.print(" " + n);
        }
    }

    private void writeAsBytes(int n) {
        this.writeAsByte((n & 0xFF0000) >> 16);
        this.writeAsByte((n & 0xFF00) >> 8);
        this.writeAsByte(n & 0xFF);
    }

    private void writeAsShort(int n) {
        if (n < 10) {
            this.writer.print("     " + n);
        } else if (n < 100) {
            this.writer.print("    " + n);
        } else if (n < 1000) {
            this.writer.print("   " + n);
        } else if (n < 10000) {
            this.writer.print("  " + n);
        } else {
            this.writer.print(" " + n);
        }
    }

    private void writeHeader(BufferedImage bufferedImage) throws PPMEncoderException {
        if (this.type == 1) {
            this.writer.println("P1");
        } else if (this.type == 2) {
            this.writer.println("P2");
        } else {
            this.writer.println("P3");
        }
        if (this.comments) {
            this.writer.println("# Created " + new Date());
        }
        this.writer.println(String.valueOf(bufferedImage.getWidth()) + " " + bufferedImage.getHeight());
        if (this.type != 1) {
            this.writer.println(this.maxValue);
        }
        if (this.writer.checkError()) {
            throw new PPMEncoderException("error writing PBM/PGM/PPM header");
        }
    }

    private void writePBM(BufferedImage bufferedImage) throws PPMEncoderException {
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n = 0;
        while (n < bufferedImage.getHeight()) {
            int n2 = 0;
            while (n2 < bufferedImage.getWidth()) {
                if (writableRaster.getSample(n2, n, 0) == this.one) {
                    this.writer.print('1');
                } else {
                    this.writer.print('0');
                }
                if ((n2 + 1) % 70 == 0) {
                    this.writer.println();
                }
                ++n2;
            }
            if (bufferedImage.getWidth() != 70) {
                this.writer.println();
            }
            ++n;
        }
        if (this.writer.checkError()) {
            throw new PPMEncoderException("error writing PBM data");
        }
    }

    private void writePGM(BufferedImage bufferedImage) throws PPMEncoderException {
        WritableRaster writableRaster = bufferedImage.getRaster();
        if (bufferedImage.getType() == 11) {
            int n = 0;
            while (n < bufferedImage.getHeight()) {
                int n2 = 0;
                while (n2 < bufferedImage.getWidth()) {
                    this.writeAsShort(writableRaster.getSample(n2, n, 0));
                    if ((n2 + 1) % 11 == 0) {
                        this.writer.println();
                    }
                    ++n2;
                }
                if (bufferedImage.getWidth() != 11) {
                    this.writer.println();
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < bufferedImage.getHeight()) {
                int n3 = 0;
                while (n3 < bufferedImage.getWidth()) {
                    this.writeAsByte(writableRaster.getSample(n3, n, 0));
                    if ((n3 + 1) % 17 == 0) {
                        this.writer.println();
                    }
                    ++n3;
                }
                if (bufferedImage.getWidth() != 17) {
                    this.writer.println();
                }
                ++n;
            }
        }
        if (this.writer.checkError()) {
            throw new PPMEncoderException("error writing PGM data");
        }
    }

    private void writePPM(BufferedImage bufferedImage) throws PPMEncoderException {
        int n = 0;
        while (n < bufferedImage.getHeight()) {
            int n2 = 0;
            while (n2 < bufferedImage.getWidth()) {
                this.writer.print(" ");
                this.writeAsBytes(bufferedImage.getRGB(n2, n));
                if ((n2 + 1) % 5 == 0) {
                    this.writer.println();
                }
                ++n2;
            }
            if (bufferedImage.getWidth() != 5) {
                this.writer.println();
            }
            ++n;
        }
        if (this.writer.checkError()) {
            throw new PPMEncoderException("error writing PPM data");
        }
    }
}

