/*
 * Decompiled with CFR 0.152.
 */
package com.pearsoneduc.ip.io;

import com.pearsoneduc.ip.io.ImageDecoder;
import com.pearsoneduc.ip.io.PPMConstants;
import com.pearsoneduc.ip.io.PPMDecoderException;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;

public class PPMDecoder
implements ImageDecoder,
PPMConstants {
    private Reader reader;
    private StreamTokenizer parser;
    private int type = 0;
    private int width;
    private int height;
    private int size;
    private int maxValue;
    private int one = 0;
    private int zero = 1;

    public PPMDecoder() throws IOException, PPMDecoderException {
        this(System.in);
    }

    public PPMDecoder(InputStream inputStream) throws IOException, PPMDecoderException {
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
        this.parser = new StreamTokenizer(this.reader);
        this.parser.commentChar(35);
        this.readHeader();
    }

    public PPMDecoder(String string) throws IOException, PPMDecoderException {
        this(new FileInputStream(string));
    }

    public boolean bitmapInversionEnabled() {
        return this.one == 0 && this.zero == 1;
    }

    public BufferedImage decodeAsBufferedImage() throws IOException, PPMDecoderException {
        if (this.type == 1) {
            return this.parsePBM();
        }
        if (this.type == 2) {
            return this.parsePGM();
        }
        return this.parsePPM();
    }

    public void disableBitmapInversion() {
        this.one = 1;
        this.zero = 0;
    }

    public void enableBitmapInversion() {
        this.one = 0;
        this.zero = 1;
    }

    public int getHeight() {
        return this.height;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getNumPixels() {
        return this.size;
    }

    public int getType() {
        return this.type;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isBinary() {
        return this.type == 1;
    }

    public boolean isGrey() {
        return this.type == 2;
    }

    public boolean isRGB() {
        return this.type == 3;
    }

    private int nextNumber() throws IOException {
        do {
            this.parser.nextToken();
            if (this.parser.ttype != -1) continue;
            throw new EOFException();
        } while (this.parser.ttype != -2);
        return (int)this.parser.nval;
    }

    private BufferedImage parsePBM() throws IOException, PPMDecoderException {
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 12);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                char c;
                while (Character.isWhitespace(c = this.readChar())) {
                }
                if (c == '1') {
                    writableRaster.setSample(n2, n, 0, this.one);
                } else if (c == '0') {
                    writableRaster.setSample(n2, n, 0, this.zero);
                } else {
                    throw new PPMDecoderException("invalid character in bitmap");
                }
                ++n2;
            }
            ++n;
        }
        return bufferedImage;
    }

    private BufferedImage parsePGM() throws IOException, PPMDecoderException {
        int n = this.maxValue > 255 ? 11 : 10;
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, n);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n2 = 0;
        while (n2 < this.height) {
            int n3 = 0;
            while (n3 < this.width) {
                this.parser.nextToken();
                if (this.parser.ttype == -1) {
                    throw new EOFException("image appears to be truncated");
                }
                if (this.parser.ttype != -2) {
                    throw new PPMDecoderException("non-numeric value for pixel at (" + n3 + "," + n2 + ")");
                }
                writableRaster.setSample(n3, n2, 0, (int)this.parser.nval);
                ++n3;
            }
            ++n2;
        }
        return bufferedImage;
    }

    private BufferedImage parsePPM() throws IOException, PPMDecoderException {
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 5);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                int n3 = 0;
                while (n3 < 3) {
                    this.parser.nextToken();
                    if (this.parser.ttype == -1) {
                        throw new EOFException("image appears to be truncated");
                    }
                    if (this.parser.ttype != -2) {
                        throw new PPMDecoderException("non-numeric value for sample " + n3 + " of pixel at (" + n2 + "," + n + ")");
                    }
                    writableRaster.setSample(n2, n, n3, (int)this.parser.nval);
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return bufferedImage;
    }

    private char readChar() throws IOException {
        int n = this.reader.read();
        if (n == -1) {
            throw new EOFException();
        }
        return (char)n;
    }

    private void readHeader() throws IOException, PPMDecoderException {
        this.parser.nextToken();
        if (this.parser.ttype != -3) {
            throw new PPMDecoderException("invalid magic number");
        }
        if (this.parser.sval.equals("P1")) {
            this.type = 1;
        } else if (this.parser.sval.equals("P2")) {
            this.type = 2;
        } else if (this.parser.sval.equals("P3")) {
            this.type = 3;
        } else {
            throw new PPMDecoderException("invalid magic number");
        }
        this.width = this.nextNumber();
        if (this.width < 1 || (this.height = this.nextNumber()) < 1) {
            throw new PPMDecoderException("invalid image dimensions");
        }
        this.size = this.width * this.height;
        if (this.type != 1) {
            this.maxValue = this.nextNumber();
        }
        if (this.type == 2 && this.maxValue < 0 || this.type == 3 && (this.maxValue < 0 || this.maxValue > 255)) {
            throw new PPMDecoderException("invalid maximum pixel value");
        }
    }
}

