/*
 * Decompiled with CFR 0.152.
 */
package com.pearsoneduc.ip.io;

import com.pearsoneduc.ip.io.ImageEncoder;
import com.pearsoneduc.ip.io.PNGEncoderException;
import com.visualtek.PNG.PNGDataEncoder;
import com.visualtek.PNG.PNGException;
import com.visualtek.PNG.PNGInfo;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PNGEncoder
implements ImageEncoder {
    private PNGDataEncoder encoder;
    private PNGInfo header = new PNGInfo();

    public PNGEncoder() {
        this(System.out);
    }

    public PNGEncoder(OutputStream outputStream) {
        this.encoder = new PNGDataEncoder(outputStream);
    }

    public PNGEncoder(String string) throws IOException {
        this(new FileOutputStream(string));
    }

    private void buildHeader(BufferedImage bufferedImage) throws PNGEncoderException {
        if (bufferedImage.getType() == 12 || bufferedImage.getType() == 11 || bufferedImage.getType() == 9 || bufferedImage.getType() == 8 || bufferedImage.getType() == 13) {
            throw new PNGEncoderException("unsupported image type");
        }
        this.header.width = bufferedImage.getWidth();
        this.header.height = bufferedImage.getHeight();
        this.header.bit_depth = (byte)8;
        this.header.color_type = bufferedImage.getType() == 10 ? (byte)0 : (byte)2;
    }

    public void encode(BufferedImage bufferedImage) throws IOException, PNGEncoderException {
        try {
            this.buildHeader(bufferedImage);
            this.encoder.writeInfo(this.header);
            WritableRaster writableRaster = bufferedImage.getRaster();
            if (bufferedImage.getType() == 10) {
                this.writeGreyscaleData(writableRaster);
            } else {
                this.writeRGBData(writableRaster);
            }
            this.encoder.writeEnd(null);
        }
        catch (PNGException pNGException) {
            throw new PNGEncoderException(pNGException.getMessage());
        }
    }

    private void writeGreyscaleData(Raster raster) throws IOException, PNGException {
        byte[] byArray = new byte[this.header.width];
        int n = 0;
        while (n < this.header.height) {
            int n2 = 0;
            while (n2 < this.header.width) {
                byArray[n2] = (byte)raster.getSample(n2, n, 0);
                ++n2;
            }
            this.encoder.writeRow(byArray);
            ++n;
        }
    }

    private void writeRGBData(Raster raster) throws IOException, PNGException {
        byte[] byArray = new byte[3 * this.header.width];
        int n = 0;
        while (n < this.header.height) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.header.width) {
                byArray[n2] = (byte)raster.getSample(n3, n, 0);
                byArray[n2 + 1] = (byte)raster.getSample(n3, n, 1);
                byArray[n2 + 2] = (byte)raster.getSample(n3, n, 2);
                ++n3;
                n2 += 3;
            }
            this.encoder.writeRow(byArray);
            ++n;
        }
    }
}

