/*
 * Decompiled with CFR 0.152.
 */
package com.pearsoneduc.ip.io;

import com.pearsoneduc.ip.io.ImageDecoder;
import com.pearsoneduc.ip.io.PNGDecoderException;
import com.visualtek.PNG.PNGData;
import com.visualtek.PNG.PNGDataDecoder;
import com.visualtek.PNG.PNGException;
import com.visualtek.PNG.PNGInfo;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PNGDecoder
implements ImageDecoder {
    private PNGDataDecoder decoder;
    private PNGInfo startInfo = new PNGInfo();
    private PNGInfo endInfo = new PNGInfo();

    public PNGDecoder() throws IOException, PNGDecoderException {
        this(System.in);
    }

    public PNGDecoder(InputStream inputStream) throws IOException, PNGDecoderException {
        try {
            this.decoder = new PNGDataDecoder(inputStream);
            this.decoder.readInfo(this.startInfo);
        }
        catch (PNGException pNGException) {
            throw new PNGDecoderException(pNGException.getMessage());
        }
    }

    public PNGDecoder(String string) throws IOException, PNGDecoderException {
        this(new FileInputStream(string));
    }

    public BufferedImage decodeAsBufferedImage() throws IOException, PNGDecoderException {
        try {
            BufferedImage bufferedImage;
            if (this.getBitDepth() != 8) {
                throw new PNGDecoderException("unsupported bit depth");
            }
            if (this.isGrey()) {
                bufferedImage = this.readGreyscaleImage();
            } else if (this.hasPalette()) {
                bufferedImage = this.readPalettedImage();
            } else if (this.isRGB()) {
                bufferedImage = this.readRGBImage();
            } else {
                throw new PNGDecoderException("unsupported PNG color type");
            }
            this.decoder.readEnd(this.endInfo);
            return bufferedImage;
        }
        catch (PNGException pNGException) {
            throw new PNGDecoderException(pNGException.getMessage());
        }
    }

    public int getBitDepth() {
        return this.startInfo.bit_depth;
    }

    public int getHeight() {
        return this.startInfo.height;
    }

    public int getNumPixels() {
        return this.startInfo.width * this.startInfo.height;
    }

    public int getRowSize() {
        return this.startInfo.rowbytes;
    }

    public int getType() {
        return this.startInfo.color_type;
    }

    public int getWidth() {
        return this.startInfo.width;
    }

    public boolean hasPalette() {
        return this.getType() == 3;
    }

    public boolean isBinary() {
        return this.getType() == 0 && this.getBitDepth() == 1;
    }

    public boolean isGrey() {
        return this.getType() == 0 || this.getType() == 4;
    }

    public boolean isRGB() {
        return this.getType() == 2 || this.getType() == 6;
    }

    private BufferedImage readGreyscaleImage() throws IOException, PNGException {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 10);
        WritableRaster writableRaster = bufferedImage.getRaster();
        byte[] byArray = new byte[this.getRowSize()];
        int n = this.getType() == 4 ? 2 : 1;
        int n2 = 0;
        while (n2 < this.getHeight()) {
            this.decoder.readRow(byArray);
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.getWidth()) {
                writableRaster.setSample(n4, n2, 0, PNGData.ubyte((byte)byArray[n3]));
                ++n4;
                n3 += n;
            }
            ++n2;
        }
        return bufferedImage;
    }

    private BufferedImage readPalettedImage() throws IOException, PNGException {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 5);
        WritableRaster writableRaster = bufferedImage.getRaster();
        byte[] byArray = new byte[this.getRowSize()];
        int n = 0;
        while (n < this.getHeight()) {
            this.decoder.readRow(byArray);
            int n2 = 0;
            while (n2 < this.getWidth()) {
                int n3 = PNGData.ubyte((byte)byArray[n2]);
                writableRaster.setSample(n2, n, 0, this.startInfo.palette[n3].getRed());
                writableRaster.setSample(n2, n, 1, this.startInfo.palette[n3].getGreen());
                writableRaster.setSample(n2, n, 2, this.startInfo.palette[n3].getBlue());
                ++n2;
            }
            ++n;
        }
        return bufferedImage;
    }

    private BufferedImage readRGBImage() throws IOException, PNGException {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 5);
        WritableRaster writableRaster = bufferedImage.getRaster();
        byte[] byArray = new byte[this.getRowSize()];
        int n = this.getType() == 6 ? 4 : 3;
        int n2 = 0;
        while (n2 < this.getHeight()) {
            this.decoder.readRow(byArray);
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.getWidth()) {
                writableRaster.setSample(n4, n2, 0, PNGData.ubyte((byte)byArray[n3]));
                writableRaster.setSample(n4, n2, 1, PNGData.ubyte((byte)byArray[n3 + 1]));
                writableRaster.setSample(n4, n2, 2, PNGData.ubyte((byte)byArray[n3 + 2]));
                ++n4;
                n3 += n;
            }
            ++n2;
        }
        return bufferedImage;
    }

    public byte[] readRow(byte[] byArray) throws IOException, PNGDecoderException {
        try {
            if (byArray == null) {
                byte[] byArray2 = new byte[this.getRowSize()];
                this.decoder.readRow(byArray2);
                return byArray2;
            }
            this.decoder.readRow(byArray);
            return null;
        }
        catch (PNGException pNGException) {
            throw new PNGDecoderException(pNGException.getMessage());
        }
    }
}

