/*
 * Decompiled with CFR 0.152.
 */
package com.pearsoneduc.ip.io;

import com.pearsoneduc.ip.io.ImageDecoder;
import com.pearsoneduc.ip.io.ImageDecoderException;
import com.pearsoneduc.ip.io.ImageEncoder;
import com.pearsoneduc.ip.io.ImageEncoderException;
import com.pearsoneduc.ip.io.JPEGDecoder;
import com.pearsoneduc.ip.io.JPEGEncoder;
import com.pearsoneduc.ip.io.PNGDecoder;
import com.pearsoneduc.ip.io.PNGEncoder;
import com.pearsoneduc.ip.io.PPMDecoder;
import com.pearsoneduc.ip.io.PPMEncoder;
import com.pearsoneduc.ip.io.SIFDecoder;
import com.pearsoneduc.ip.io.SIFEncoder;
import java.io.IOException;

public class ImageFile {
    public static ImageDecoder createImageDecoder(String string) throws IOException, ImageDecoderException {
        if (string.endsWith(".pbm") || string.endsWith(".pgm") || string.endsWith(".ppm")) {
            return new PPMDecoder(string);
        }
        if (string.endsWith(".sif")) {
            return new SIFDecoder(string);
        }
        if (string.endsWith(".png")) {
            return new PNGDecoder(string);
        }
        if (string.endsWith(".jpg") || string.endsWith(".jpeg")) {
            return new JPEGDecoder(string);
        }
        throw new ImageDecoderException("cannot determine file format");
    }

    public static ImageEncoder createImageEncoder(String string) throws IOException, ImageEncoderException {
        if (string.endsWith(".pbm") || string.endsWith(".pgm") || string.endsWith(".ppm")) {
            return new PPMEncoder(string);
        }
        if (string.endsWith(".sif")) {
            return new SIFEncoder(string);
        }
        if (string.endsWith(".png")) {
            return new PNGEncoder(string);
        }
        if (string.endsWith(".jpg") || string.endsWith(".jpeg")) {
            return new JPEGEncoder(string);
        }
        throw new ImageEncoderException("cannot determine file format");
    }
}

