/*
 * Decompiled with CFR 0.152.
 */
package com.pearsoneduc.ip.gui;

import com.pearsoneduc.ip.gui.ImageView;
import com.pearsoneduc.ip.gui.WindowMonitor;
import com.pearsoneduc.ip.io.ImageDecoder;
import com.pearsoneduc.ip.io.ImageDecoderException;
import com.pearsoneduc.ip.io.ImageFile;
import com.pearsoneduc.ip.op.OperationException;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public abstract class OperationViewer
extends JFrame {
    protected BufferedImage inputImage;
    protected BufferedImage outputImage;
    private ImageView inputView;
    private ImageView outputView;

    public OperationViewer(String string) throws IOException, ImageDecoderException, OperationException {
        this.readImage(string);
        if (!this.imageOK()) {
            throw new OperationException("image is unsuitable for operation");
        }
        this.processImage();
        this.inputView = new ImageView(this.inputImage);
        this.outputView = new ImageView(this.outputImage);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add((Component)new JScrollPane(this.inputView), "input");
        jTabbedPane.add((Component)new JScrollPane(this.outputView), "output");
        this.getContentPane().add(jTabbedPane);
        this.addWindowListener(new WindowMonitor());
    }

    public abstract boolean imageOK();

    public abstract void processImage();

    public void readImage(String string) throws IOException, ImageDecoderException {
        ImageDecoder imageDecoder = ImageFile.createImageDecoder(string);
        this.inputImage = imageDecoder.decodeAsBufferedImage();
    }
}

