/*
 * Decompiled with CFR 0.152.
 */
package com.pearsoneduc.ip.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import javax.swing.JLabel;
import javax.swing.Scrollable;

public class ImageView
extends JLabel
implements Scrollable {
    private static final int DEFAULT_VIEW_WIDTH = 256;
    private static final int DEFAULT_VIEW_HEIGHT = 256;
    private BufferedImage image;
    private BufferedImageOp operation;
    private Dimension viewSize;

    public ImageView(BufferedImage bufferedImage) {
        this(bufferedImage, null);
    }

    public ImageView(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp) {
        this.setImage(bufferedImage);
        this.setOperation(bufferedImageOp);
        this.viewSize = new Dimension(Math.min(256, this.image.getWidth()), Math.min(256, this.image.getHeight()));
        this.setPreferredSize(new Dimension(this.image.getWidth(), this.image.getHeight()));
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.viewSize;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return this.image.getWidth() / 10;
        }
        return this.image.getHeight() / 10;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 1;
    }

    public void paintComponent(Graphics graphics) {
        if (this.operation != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.drawImage(this.image, this.operation, 0, 0);
        } else {
            graphics.drawImage(this.image, 0, 0, this);
        }
    }

    public void setImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
    }

    public void setOperation(BufferedImageOp bufferedImageOp) {
        this.operation = bufferedImageOp;
    }

    public void setViewSize(Dimension dimension) {
        this.viewSize.setSize(dimension);
    }
}

