/*
 * Decompiled with CFR 0.152.
 */
package com.pearsoneduc.ip.gui;

import com.pearsoneduc.ip.gui.WindowMonitor;
import com.pearsoneduc.ip.io.ImageDecoder;
import com.pearsoneduc.ip.io.ImageDecoderException;
import com.pearsoneduc.ip.io.ImageFile;
import com.pearsoneduc.ip.op.OperationException;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class ImageSelector
extends JFrame
implements ActionListener {
    private BufferedImage sourceImage;
    private Hashtable images;
    private JLabel view;
    private JComboBox selector;

    public ImageSelector(String string) throws IOException, ImageDecoderException, OperationException {
        super(string);
        this.readImage(string);
        if (!this.imageOK()) {
            throw new OperationException("invalid input image");
        }
        this.images = new Hashtable();
        Vector vector = this.generateImages();
        ImageIcon imageIcon = (ImageIcon)this.images.get((String)vector.firstElement());
        this.view = new JLabel(imageIcon);
        this.selector = new JComboBox(vector);
        this.selector.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(this.selector);
        Container container = this.getContentPane();
        container.add((Component)this.view, "Center");
        container.add((Component)jPanel, "South");
        this.addWindowListener(new WindowMonitor());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = ((JComboBox)actionEvent.getSource()).getSelectedItem();
        ImageIcon imageIcon = (ImageIcon)this.images.get(object);
        this.view.setIcon(imageIcon);
    }

    public void addImage(String string, ImageIcon imageIcon) {
        this.images.put(string, imageIcon);
    }

    public abstract Vector generateImages();

    public BufferedImage getSourceImage() {
        return this.sourceImage;
    }

    public abstract boolean imageOK();

    public void readImage(String string) throws IOException, ImageDecoderException {
        ImageDecoder imageDecoder = ImageFile.createImageDecoder(string);
        this.sourceImage = imageDecoder.decodeAsBufferedImage();
    }
}

