/*
 * Decompiled with CFR 0.152.
 */
import com.pearsoneduc.ip.gui.ViewWithROI;
import com.pearsoneduc.ip.gui.WindowMonitor;
import com.pearsoneduc.ip.io.ImageDecoder;
import com.pearsoneduc.ip.io.ImageDecoderException;
import com.pearsoneduc.ip.io.ImageFile;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.swing.JFrame;

public class MeanROI
extends JFrame
implements MouseListener,
MouseMotionListener {
    private BufferedImage image;
    private ViewWithROI view;
    private MeanInfo info;

    public MeanROI(String string) throws IOException, ImageDecoderException {
        super("MeanROI: " + string);
        this.readImage(string);
        this.view = new ViewWithROI(this.image);
        this.view.addMouseListener(this);
        this.view.addMouseMotionListener(this);
        double d = this.meanValue(this.image);
        this.info = new MeanInfo(d);
        Container container = this.getContentPane();
        container.add((Component)this.view, "Center");
        container.add((Component)this.info, "South");
        this.addWindowListener((WindowListener)new WindowMonitor());
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            try {
                MeanROI meanROI = new MeanROI(stringArray[0]);
                meanROI.pack();
                ((Component)meanROI).setVisible(true);
            }
            catch (Exception exception) {
                System.err.println(exception);
                System.exit(1);
            }
        } else {
            System.err.println("usage: java MeanROI <imagefile>");
            System.exit(1);
        }
    }

    public double meanValue(BufferedImage bufferedImage) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        double d = 0.0;
        int n = 0;
        while (n < bufferedImage.getHeight()) {
            int n2 = 0;
            while (n2 < bufferedImage.getWidth()) {
                d += (double)writableRaster.getSample(n2, n, 0);
                ++n2;
            }
            ++n;
        }
        return d / (double)(bufferedImage.getWidth() * bufferedImage.getHeight());
    }

    public double meanValue(BufferedImage bufferedImage, Rectangle rectangle) {
        return this.meanValue(bufferedImage.getSubimage(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        Rectangle rectangle = this.view.getROI();
        if (point.x > rectangle.x && point.y > rectangle.y) {
            rectangle.width = point.x - rectangle.x + 1;
            rectangle.height = point.y - rectangle.y + 1;
            this.view.setROI(rectangle);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        this.view.setROI(point.x, point.y, 0, 0);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Rectangle rectangle = this.view.getROI();
        if (rectangle.width > 0 && rectangle.height > 0) {
            double d = this.meanValue(this.image, rectangle);
            this.info.display(d);
        }
    }

    public void readImage(String string) throws IOException, ImageDecoderException {
        ImageDecoder imageDecoder = ImageFile.createImageDecoder((String)string);
        this.image = imageDecoder.decodeAsBufferedImage();
        if (this.image.getType() != 10) {
            throw new ImageDecoderException("invalid image type - must be grey");
        }
    }
}

