/*
 * Decompiled with CFR 0.152.
 */
import com.pearsoneduc.ip.gui.ImageView;
import com.pearsoneduc.ip.gui.WindowMonitor;
import com.pearsoneduc.ip.io.ImageDecoder;
import com.pearsoneduc.ip.io.ImageDecoderException;
import com.pearsoneduc.ip.io.ImageFile;
import com.pearsoneduc.ip.op.BinaryCloseOp;
import com.pearsoneduc.ip.op.BinaryDilateOp;
import com.pearsoneduc.ip.op.BinaryErodeOp;
import com.pearsoneduc.ip.op.BinaryOpenOp;
import com.pearsoneduc.ip.op.BinaryStructElement;
import com.pearsoneduc.ip.op.OperationException;
import com.pearsoneduc.ip.util.IntervalTimer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class BinaryMorphologyTool
extends JFrame
implements Runnable,
ActionListener {
    private int width;
    private int height;
    private BufferedImage inputImage;
    private BufferedImage outputImage;
    private StructElementPane controlPane;
    private ImageView inputView;
    private ImageView outputView;
    private JMenu fileMenu;
    private JMenu configMenu;
    private JMenu taskMenu;
    private JFileChooser fileChooser = new JFileChooser(System.getProperty("user.dir"));
    private JLabel statusBar = new JLabel("Ready");
    private IntervalTimer timer = new IntervalTimer();
    private BufferedImageOp operation;
    private Thread operationThread;
    private boolean operating;

    public BinaryMorphologyTool(String string, int n, int n2) throws IOException, ImageDecoderException, OperationException {
        super("BinaryMorphologyTool: " + string);
        this.width = n;
        this.height = n2;
        ImageDecoder imageDecoder = ImageFile.createImageDecoder((String)string);
        this.inputImage = imageDecoder.decodeAsBufferedImage();
        if (this.inputImage.getType() != 10 && this.inputImage.getType() != 12) {
            throw new OperationException("invalid image type");
        }
        this.inputView = new ImageView(this.inputImage);
        this.inputView.setToolTipText("Input image");
        this.outputImage = this.inputImage;
        this.outputView = new ImageView(this.outputImage);
        this.outputView.setToolTipText("Output image");
        JPanel jPanel = new JPanel(new FlowLayout(1, 15, 5));
        jPanel.add(new JScrollPane((Component)this.inputView));
        this.controlPane = new StructElementPane(this.width, this.height);
        jPanel.add(this.controlPane);
        jPanel.add(new JScrollPane((Component)this.outputView));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        jPanel2.add((Component)this.statusBar, "South");
        this.setContentPane(jPanel2);
        JMenuBar jMenuBar = new JMenuBar();
        this.createFileMenu();
        this.createConfigMenu();
        this.createTaskMenu();
        jMenuBar.add(this.fileMenu);
        jMenuBar.add(this.configMenu);
        jMenuBar.add(this.taskMenu);
        this.setJMenuBar(jMenuBar);
        this.addWindowListener((WindowListener)new WindowMonitor());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Load SE")) {
            this.loadStructuringElement();
            this.repaint();
        } else if (string.equals("Save SE")) {
            this.saveStructuringElement();
            this.repaint();
        } else if (string.equals("Exit")) {
            ((Component)this).setVisible(false);
            this.dispose();
            System.exit(0);
        } else if (string.equals("Set all SE pixels")) {
            this.controlPane.setPixels();
        } else if (string.equals("Clear all SE pixels")) {
            this.controlPane.clearPixels();
        } else if (string.equals("Copy output to input")) {
            this.copyOutputToInput();
            this.repaint();
        } else if (string.equals("Erode")) {
            this.erode();
        } else if (string.equals("Dilate")) {
            this.dilate();
        } else if (string.equals("Open")) {
            this.open();
        } else if (string.equals("Close")) {
            this.close();
        }
    }

    public void close() {
        if (this.operating) {
            this.statusBar.setText("Not ready yet!...");
        } else {
            BinaryStructElement binaryStructElement = this.controlPane.getStructuringElement();
            this.operation = new BinaryCloseOp(binaryStructElement);
            this.statusBar.setText("Closing image...");
            this.operationThread = new Thread(this);
            this.setPriority();
            this.operationThread.start();
        }
    }

    public void copyOutputToInput() {
        if (JOptionPane.showConfirmDialog(this, "Input will be lost!  Are you sure?", "Copy output to input", 2) == 0) {
            this.inputImage = this.outputImage;
            this.inputView.setImage(this.inputImage);
            this.inputView.repaint();
        }
    }

    public void createConfigMenu() {
        this.configMenu = new JMenu("Configure");
        this.configMenu.setMnemonic('C');
        String[] stringArray = new String[]{"Set all SE pixels", "Clear all SE pixels", "Copy output to input"};
        char[] cArray = new char[]{'S', 'C', 'O'};
        int n = 0;
        while (n < stringArray.length) {
            JMenuItem jMenuItem = new JMenuItem(stringArray[n]);
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(cArray[n], 1, false));
            jMenuItem.addActionListener(this);
            this.configMenu.add(jMenuItem);
            ++n;
        }
    }

    public void createFileMenu() {
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic('F');
        String[] stringArray = new String[]{"Load SE", "Save SE", "Exit"};
        char[] cArray = new char[]{'L', 'S', 'X'};
        int n = 0;
        while (n < stringArray.length) {
            JMenuItem jMenuItem = new JMenuItem(stringArray[n], cArray[n]);
            jMenuItem.addActionListener(this);
            this.fileMenu.add(jMenuItem);
            ++n;
        }
    }

    public void createTaskMenu() {
        this.taskMenu = new JMenu("Task");
        this.taskMenu.setMnemonic('T');
        String[] stringArray = new String[]{"Erode", "Dilate", "Open", "Close"};
        char[] cArray = new char[]{'E', 'D', 'O', 'C'};
        int n = 0;
        while (n < stringArray.length) {
            JMenuItem jMenuItem = new JMenuItem(stringArray[n]);
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(cArray[n], 2, false));
            jMenuItem.addActionListener(this);
            this.taskMenu.add(jMenuItem);
            ++n;
        }
    }

    public void dilate() {
        if (this.operating) {
            this.statusBar.setText("Not ready yet!...");
        } else {
            BinaryStructElement binaryStructElement = this.controlPane.getStructuringElement();
            this.operation = new BinaryDilateOp(binaryStructElement);
            this.statusBar.setText("Dilating image...");
            this.operationThread = new Thread(this);
            this.setPriority();
            this.operationThread.start();
        }
    }

    public void erode() {
        if (this.operating) {
            this.statusBar.setText("Not ready yet!...");
        } else {
            BinaryStructElement binaryStructElement = this.controlPane.getStructuringElement();
            this.operation = new BinaryErodeOp(binaryStructElement);
            this.statusBar.setText("Eroding image...");
            this.operationThread = new Thread(this);
            this.setPriority();
            this.operationThread.start();
        }
    }

    public void loadStructuringElement() {
        block4: {
            this.fileChooser.setDialogTitle("Load structuring element");
            if (this.fileChooser.showOpenDialog(this) != 0) break block4;
            try {
                BinaryStructElement binaryStructElement = new BinaryStructElement((Reader)new FileReader(this.fileChooser.getSelectedFile()));
                if (binaryStructElement.getWidth() != this.width || binaryStructElement.getHeight() != this.height) {
                    throw new IOException("Error: invalid structuring element dimensions!");
                }
                this.controlPane.setToStructuringElement(binaryStructElement);
                this.statusBar.setText("Structuring element loaded");
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.statusBar.setText("Error: cannot access structuring element!");
            }
            catch (Exception exception) {
                this.statusBar.setText("Error: " + exception.getMessage());
            }
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            try {
                int n = 3;
                int n2 = 3;
                if (stringArray.length > 2) {
                    n = Integer.parseInt(stringArray[1]);
                    n2 = Integer.parseInt(stringArray[2]);
                }
                BinaryMorphologyTool binaryMorphologyTool = new BinaryMorphologyTool(stringArray[0], n, n2);
                binaryMorphologyTool.pack();
                ((Component)binaryMorphologyTool).setVisible(true);
            }
            catch (Exception exception) {
                System.err.println(exception);
                System.exit(1);
            }
        } else {
            System.err.println("usage: java BinaryMorphologyTool <imagefile> [<width> <height>]");
            System.exit(1);
        }
    }

    public void open() {
        if (this.operating) {
            this.statusBar.setText("Not ready yet!...");
        } else {
            BinaryStructElement binaryStructElement = this.controlPane.getStructuringElement();
            this.operation = new BinaryOpenOp(binaryStructElement);
            this.statusBar.setText("Opening image...");
            this.operationThread = new Thread(this);
            this.setPriority();
            this.operationThread.start();
        }
    }

    public void run() {
        this.operating = true;
        this.timer.start();
        this.outputImage = this.operation.filter(this.inputImage, null);
        this.outputView.setImage(this.outputImage);
        this.outputView.repaint();
        this.statusBar.setText("Operation finished [" + this.timer.stop() + " sec]");
        this.operating = false;
    }

    public void saveStructuringElement() {
        block3: {
            this.fileChooser.setDialogTitle("Save structuring element");
            if (this.fileChooser.showSaveDialog(this) != 0) break block3;
            try {
                int n;
                File file = this.fileChooser.getSelectedFile();
                if (file.exists() && (n = JOptionPane.showConfirmDialog(this, "File will be overwritten!  Are you sure?", "File exists", 2)) != 0) {
                    return;
                }
                BinaryStructElement binaryStructElement = this.controlPane.getStructuringElement();
                binaryStructElement.write((Writer)new FileWriter(file));
                this.fileChooser.rescanCurrentDirectory();
                this.statusBar.setText("Structuring element saved");
            }
            catch (Exception exception) {
                this.statusBar.setText("Error: " + exception.getMessage());
            }
        }
    }

    public void setPriority() {
        int n = Thread.currentThread().getPriority();
        this.operationThread.setPriority(Math.max(1, n - 1));
    }
}

