/*
 * Decompiled with CFR 0.152.
 */
package com.visualtek.PNG;

import com.visualtek.PNG.PNGData;
import com.visualtek.PNG.PNGException;
import com.visualtek.PNG.PNGInfo;
import com.visualtek.PNG.PNGRowInfo;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class PNGDataDecoder
extends PNGData {
    private InputStream png_istream;
    private Inflater zstream;

    public PNGDataDecoder(InputStream inputStream) {
        this.png_istream = inputStream;
        this.zstream = new Inflater();
        this.zbuf_size = 8192;
        this.zbuf = new byte[this.zbuf_size];
    }

    public void readInfo(PNGInfo pNGInfo) throws PNGException, IOException {
        this.readData(pNGInfo.signature, 8);
        if (this.memCompare(pNGInfo.signature, PNGData.png_sig, 8) != 0) {
            throw new PNGException("Not a PNG file");
        }
        byte[] byArray = new byte[4];
        while (true) {
            this.readData(byArray, 4);
            int n = this.getInt32(byArray);
            this.resetCRC();
            this.crcRead(this.chunk_name, 4);
            if (this.memCompare(this.chunk_name, PNGData.png_IHDR, 4) == 0) {
                this.handleIHDR(pNGInfo, n);
                continue;
            }
            if (this.memCompare(this.chunk_name, PNGData.png_PLTE, 4) == 0) {
                this.handlePLTE(pNGInfo, n);
                continue;
            }
            if (this.memCompare(this.chunk_name, PNGData.png_IEND, 4) == 0) {
                this.handleIEND(pNGInfo, n);
                continue;
            }
            if (this.memCompare(this.chunk_name, PNGData.png_IDAT, 4) == 0) {
                if ((this.mode & 1) == 0) {
                    throw new PNGException("Missing IHDR before IDAT");
                }
                if (this.color_type == 3 && (this.mode & 2) == 0) {
                    throw new PNGException("Missing PLTE before IDAT");
                }
                this.idat_size = n;
                this.mode |= 4;
                return;
            }
            this.handleUnknown(pNGInfo, n);
        }
    }

    public void readRow(byte[] byArray) throws PNGException, IOException {
        if ((this.flags & 0x40) == 0) {
            this.readStartRow();
        }
        if ((this.mode & 4) == 0) {
            throw new PNGException("Invalid attempt to read row data");
        }
        int n = this.irowbytes;
        int n2 = 0;
        do {
            int n3;
            if (this.zstream.needsInput()) {
                byte[] byArray2 = new byte[4];
                while (this.idat_size == 0) {
                    this.crcFinish(0);
                    this.readData(byArray2, 4);
                    this.idat_size = this.getInt32(byArray2);
                    this.resetCRC();
                    this.crcRead(this.chunk_name, 4);
                    if (this.memCompare(this.chunk_name, PNGData.png_IDAT, 4) == 0) continue;
                    throw new PNGException("Not enough image data");
                }
                int n4 = this.zbuf_size;
                if (this.zbuf_size > this.idat_size) {
                    n4 = this.idat_size;
                }
                this.crcRead(this.zbuf, n4);
                this.idat_size -= n4;
                this.zstream.setInput(this.zbuf, 0, n4);
            }
            try {
                n3 = this.zstream.inflate(this.row_buf, n2, n);
            }
            catch (DataFormatException dataFormatException) {
                throw new PNGException("Zip error: " + dataFormatException.getMessage());
            }
            n2 += n3;
            n -= n3;
            if (!this.zstream.finished()) continue;
            if (this.zstream.getRemaining() != 0 || this.idat_size != 0) {
                throw new PNGException("Extra compressed data");
            }
            this.mode |= 8;
            this.flags |= 0x20;
            break;
        } while (n > 0);
        this.row_info.color_type = this.color_type;
        this.row_info.width = this.iwidth;
        this.row_info.channels = this.channels;
        this.row_info.bit_depth = this.bit_depth;
        this.row_info.pixel_depth = this.pixel_depth;
        this.row_info.rowbytes = this.row_info.width * this.row_info.pixel_depth + 7 >> 3;
        this.readFilterRow(this.row_info, this.row_buf, 1, this.prev_row, 1, PNGData.ubyte(this.row_buf[0]));
        this.memCopy(this.prev_row, this.row_buf, this.rowbytes + 1);
        if (byArray != null) {
            this.combineRow(byArray, 255);
        }
        this.readFinishRow();
    }

    public void readEnd(PNGInfo pNGInfo) throws PNGException, IOException {
        byte[] byArray = new byte[4];
        this.crcFinish(0);
        do {
            this.readData(byArray, 4);
            int n = this.getInt32(byArray);
            this.resetCRC();
            this.crcRead(this.chunk_name, 4);
            if (this.memCompare(this.chunk_name, PNGData.png_IHDR, 4) == 0) {
                this.handleIHDR(pNGInfo, n);
                continue;
            }
            if (this.memCompare(this.chunk_name, PNGData.png_PLTE, 4) == 0) {
                this.handlePLTE(pNGInfo, n);
                continue;
            }
            if (this.memCompare(this.chunk_name, PNGData.png_IDAT, 4) == 0) {
                if (n <= 0 && (this.mode & 8) == 0) continue;
                throw new PNGException("Too many IDAT's found");
            }
            if (this.memCompare(this.chunk_name, PNGData.png_IEND, 4) == 0) {
                this.handleIEND(pNGInfo, n);
                continue;
            }
            this.handleUnknown(pNGInfo, n);
        } while ((this.mode & 0x10) == 0);
    }

    private void handleIHDR(PNGInfo pNGInfo, int n) throws PNGException, IOException {
        byte[] byArray = new byte[13];
        if (this.mode != 0) {
            throw new PNGException("Out of place IHDR");
        }
        if (n != 13) {
            throw new PNGException("Invalid IHDR chunk");
        }
        this.mode |= 1;
        this.crcRead(byArray, 13);
        this.crcFinish(0);
        this.width = this.getInt32(byArray);
        this.height = this.getInt32(byArray, 4);
        this.bit_depth = byArray[8];
        this.color_type = byArray[9];
        byte by = byArray[10];
        byte by2 = byArray[11];
        byte by3 = byArray[12];
        if (this.width == 0 || this.width > Integer.MAX_VALUE || this.height == 0 || this.height > Integer.MAX_VALUE) {
            throw new PNGException("Invalid image size in IHDR");
        }
        if (this.bit_depth != 1 && this.bit_depth != 2 && this.bit_depth != 4 && this.bit_depth != 8 && this.bit_depth != 16) {
            throw new PNGException("Invalid bit depth in IHDR");
        }
        if (this.color_type < 0 || this.color_type == 1 || this.color_type == 5 || this.color_type > 6) {
            throw new PNGException("Invalid color type in IHDR");
        }
        if (this.color_type == 3 && this.bit_depth > 8 || (this.color_type == 2 || this.color_type == 4 || this.color_type == 6) && this.bit_depth < 8) {
            throw new PNGException("Invalid color type/bit depth combination in IHDR");
        }
        if (by3 > 1) {
            throw new PNGException("Unknown interlace method in IHDR");
        }
        if (by > 0) {
            throw new PNGException("Unknown compression method in IHDR");
        }
        if (by2 > 0) {
            throw new PNGException("Unknown filter method in IHDR");
        }
        switch (this.color_type) {
            case 0: 
            case 3: {
                this.channels = 1;
                break;
            }
            case 2: {
                this.channels = (byte)3;
                break;
            }
            case 4: {
                this.channels = (byte)2;
                break;
            }
            case 6: {
                this.channels = (byte)4;
                break;
            }
        }
        this.pixel_depth = (byte)(this.bit_depth * this.channels);
        this.rowbytes = this.width * this.pixel_depth + 7 >> 3;
        this.readIHDR(pNGInfo, this.width, this.height, this.bit_depth, this.color_type, by, by2, by3);
    }

    private void handlePLTE(PNGInfo pNGInfo, int n) throws PNGException, IOException {
        if ((this.mode & 1) == 0) {
            throw new PNGException("Missing IHDR before PLTE");
        }
        if ((this.mode & 4) != 0) {
            this.warning("Invalid PLTE after IDAT");
            this.crcFinish(n);
            return;
        }
        if ((this.mode & 2) != 0) {
            throw new PNGException("Duplicate PLTE chunk");
        }
        this.mode |= 2;
        if (n % 3 != 0) {
            if (this.color_type != 3) {
                this.warning("Invalid palette chunk");
                this.crcFinish(n);
                return;
            }
            throw new PNGException("Invalid palette chunk");
        }
        int n2 = n / 3;
        this.palette = new Color[n2];
        this.flags |= 0x1000;
        byte[] byArray = new byte[3];
        int n3 = 0;
        while (n3 < n2) {
            this.crcRead(byArray, 3);
            this.palette[n3] = new Color(PNGData.ubyte(byArray[0]), PNGData.ubyte(byArray[1]), PNGData.ubyte(byArray[2]));
            ++n3;
        }
        if (this.color_type == 3) {
            if (this.crcFinish(0) != 0) {
                return;
            }
        } else if (this.crcError() != 0) {
            String string = "CRC error in " + this.chunk_name;
            if ((this.flags & 0x100) == 0) {
                if ((this.flags & 0x200) != 0) {
                    throw new PNGException(string);
                }
                this.warning(string);
                return;
            }
            if ((this.flags & 0x200) == 0) {
                this.warning(string);
            }
        }
        this.num_palette = (short)n2;
        this.readPLTE(pNGInfo, this.palette, n2);
    }

    private void handleIEND(PNGInfo pNGInfo, int n) throws PNGException, IOException {
        if ((this.mode & 1) == 0 || (this.mode & 4) == 0) {
            throw new PNGException("No image in file");
        }
        this.mode |= 0x18;
        if (n != 0) {
            this.warning("Incorrect IEND chunk length");
            this.crcFinish(n);
        }
    }

    private void handleUnknown(PNGInfo pNGInfo, int n) throws PNGException, IOException {
        this.checkChunkName(this.chunk_name);
        if ((this.chunk_name[0] & 0x20) == 0) {
            String string = "Unknown critical chunk " + this.chunk_name;
            throw new PNGException(string);
        }
        if ((this.mode & 4) != 0) {
            this.mode |= 8;
        }
        this.crcFinish(n);
    }

    private void checkChunkName(byte[] byArray) throws PNGException {
        if (byArray[0] < 41 || byArray[0] > 122 || byArray[0] > 90 && byArray[0] < 97 || byArray[1] < 41 || byArray[1] > 122 || byArray[1] > 90 && byArray[1] < 97 || byArray[2] < 41 || byArray[2] > 122 || byArray[2] > 90 && byArray[2] < 97 || byArray[3] < 41 || byArray[3] > 122 || byArray[3] > 90 && byArray[3] < 97) {
            throw new PNGException("Invalid chunk type");
        }
    }

    private void readIHDR(PNGInfo pNGInfo, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        pNGInfo.width = n;
        pNGInfo.height = n2;
        pNGInfo.bit_depth = (byte)n3;
        pNGInfo.color_type = (byte)n4;
        pNGInfo.compression_type = (byte)n5;
        pNGInfo.filter_type = (byte)n6;
        pNGInfo.interlace_type = (byte)n7;
        pNGInfo.channels = pNGInfo.color_type == 3 ? (byte)1 : ((pNGInfo.color_type & 2) != 0 ? (byte)3 : (byte)1);
        if ((pNGInfo.color_type & 4) != 0) {
            pNGInfo.channels = (byte)(pNGInfo.channels + 1);
        }
        pNGInfo.pixel_depth = (byte)(pNGInfo.channels * pNGInfo.bit_depth);
        pNGInfo.rowbytes = pNGInfo.width * pNGInfo.pixel_depth + 7 >> 3;
    }

    private void readPLTE(PNGInfo pNGInfo, Color[] colorArray, int n) {
        pNGInfo.palette = colorArray;
        pNGInfo.num_palette = (short)n;
        pNGInfo.valid |= 8;
    }

    private void readStartRow() {
        if (this.interlaced != 0) {
            this.num_rows = (this.transformations & 2) == 0 ? (this.height + PNGData.png_pass_yinc[0] - 1 - PNGData.png_pass_ystart[0]) / PNGData.png_pass_yinc[0] : this.height;
            this.iwidth = (this.width + PNGData.png_pass_inc[this.pass] - 1 - PNGData.png_pass_start[this.pass]) / PNGData.png_pass_inc[this.pass];
            this.irowbytes = (this.iwidth * this.pixel_depth + 7 >> 3) + 1;
        } else {
            this.num_rows = this.height;
            this.iwidth = this.width;
            this.irowbytes = this.rowbytes + 1;
        }
        byte by = this.pixel_depth;
        int n = this.width + 7 & 0xFFFFFFF8;
        n = (n * by + 7 >> 3) + 1 + (by + 7 >> 3);
        this.row_buf = new byte[n];
        this.prev_row = new byte[this.rowbytes + 1];
        this.memSet(this.prev_row, 0, this.rowbytes + 1);
        this.flags |= 0x40;
    }

    private void readFilterRow(PNGRowInfo pNGRowInfo, byte[] byArray, int n, byte[] byArray2, int n2, int n3) throws PNGException {
        switch (n3) {
            case 1: {
                int n4;
                int n5 = n4 = (this.pixel_depth + 7) / 8;
                int n6 = n4;
                int n7 = 0;
                while (n5 < this.rowbytes) {
                    int n8 = PNGData.ubyte(byArray[n6 + n]) + PNGData.ubyte(byArray[n7 + n]) & 0xFF;
                    byArray[n6 + n] = (byte)n8;
                    ++n5;
                    ++n6;
                    ++n7;
                }
                return;
            }
            case 2: {
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                while (n9 < this.rowbytes) {
                    int n12 = PNGData.ubyte(byArray[n10 + n]) + PNGData.ubyte(byArray2[n11 + n2]) & 0xFF;
                    byArray[n10 + n] = (byte)n12;
                    ++n9;
                    ++n10;
                    ++n11;
                }
                return;
            }
            case 3: {
                int n13;
                int n14 = (this.pixel_depth + 7) / 8;
                int n15 = 0;
                int n16 = 0;
                int n17 = 0;
                while (n15 < n14) {
                    n13 = PNGData.ubyte(byArray[n16 + n]) + PNGData.ubyte(byArray2[n17 + n2]) / 2 & 0xFF;
                    byArray[n16 + n] = (byte)n13;
                    ++n15;
                    ++n16;
                    ++n17;
                }
                int n18 = 0;
                while (n15 < this.rowbytes) {
                    n13 = PNGData.ubyte(byArray[n16 + n]) + (PNGData.ubyte(byArray2[n17 + n2]) + PNGData.ubyte(byArray[n18 + n])) / 2 & 0xFF;
                    byArray[n16 + n] = (byte)n13;
                    ++n15;
                    ++n16;
                    ++n18;
                    ++n17;
                }
                return;
            }
            case 4: {
                int n19 = (this.pixel_depth + 7) / 8;
                int n20 = 0;
                int n21 = 0;
                int n22 = 0;
                int n23 = -n19;
                int n24 = -n19;
                while (n20 < this.rowbytes) {
                    int n25;
                    int n26;
                    int n27 = PNGData.ubyte(byArray2[n22 + n2]);
                    if (n20 >= n19) {
                        n26 = PNGData.ubyte(byArray2[n24 + n2]);
                        n25 = PNGData.ubyte(byArray[n23 + n]);
                    } else {
                        n26 = 0;
                        n25 = 0;
                    }
                    int n28 = n25 + n27 - n26;
                    int n29 = this.iAbs(n28 - n25);
                    int n30 = this.iAbs(n28 - n27);
                    int n31 = this.iAbs(n28 - n26);
                    n28 = n29 <= n30 && n29 <= n31 ? n25 : (n30 <= n31 ? n27 : n26);
                    int n32 = PNGData.ubyte(byArray[n21 + n]) + n28 & 0xFF;
                    byArray[n21 + n] = (byte)n32;
                    ++n20;
                    ++n21;
                    ++n22;
                    ++n23;
                    ++n24;
                }
                return;
            }
            default: {
                throw new PNGException("Bad adaptive filter type");
            }
            case 0: 
        }
    }

    private void readFinishRow() throws PNGException, IOException {
        block14: {
            ++this.row_number;
            if (this.row_number < this.num_rows) {
                return;
            }
            if (this.interlaced != 0) {
                this.row_number = 0;
                this.memSet(this.prev_row, 0, this.rowbytes + 1);
                do {
                    this.pass = (byte)(this.pass + 1);
                    if (this.pass >= 7) break;
                    this.iwidth = (this.width + PNGData.png_pass_inc[this.pass] - 1 - PNGData.png_pass_start[this.pass]) / PNGData.png_pass_inc[this.pass];
                    this.irowbytes = (this.iwidth * this.pixel_depth + 7 >> 3) + 1;
                    if ((this.transformations & 2) == 0) {
                        this.num_rows = (this.height + PNGData.png_pass_yinc[this.pass] - 1 - PNGData.png_pass_ystart[this.pass]) / PNGData.png_pass_yinc[this.pass];
                        if (this.num_rows == 0) continue;
                    }
                    if ((this.transformations & 2) != 0) break;
                } while (this.iwidth == 0);
                if (this.pass < 7) {
                    return;
                }
            }
            if ((this.flags & 0x20) == 0) {
                byte[] byArray = new byte[1];
                do {
                    if (this.zstream.needsInput()) {
                        byte[] byArray2 = new byte[4];
                        while (this.idat_size == 0) {
                            this.crcFinish(0);
                            this.readData(byArray2, 4);
                            this.idat_size = this.getInt32(byArray2);
                            this.resetCRC();
                            this.crcRead(this.chunk_name, 4);
                            if (this.memCompare(this.chunk_name, PNGData.png_IDAT, 4) == 0) continue;
                            throw new PNGException("Not enough image data");
                        }
                        int n = this.zbuf_size;
                        if (this.zbuf_size > this.idat_size) {
                            n = this.idat_size;
                        }
                        this.crcRead(this.zbuf, n);
                        this.idat_size -= n;
                        this.zstream.setInput(this.zbuf, 0, n);
                    }
                    try {
                        this.zstream.inflate(byArray, 0, 1);
                    }
                    catch (DataFormatException dataFormatException) {
                        throw new PNGException("Zip error: " + dataFormatException.getMessage());
                    }
                    if (!this.zstream.finished()) continue;
                    if (this.zstream.getRemaining() != 0 || this.idat_size != 0) {
                        throw new PNGException("Extra compressed data");
                    }
                    this.mode |= 8;
                    this.flags |= 0x20;
                    break block14;
                } while (this.zstream.getRemaining() != 0);
                throw new PNGException("Extra compressed data");
            }
        }
        if (this.idat_size != 0 || this.zstream.getRemaining() != 0) {
            throw new PNGException("Extra compression data");
        }
        this.zstream.reset();
        this.mode |= 8;
    }

    private void combineRow(byte[] byArray, int n) {
        if (n == 255) {
            this.memCopy(byArray, 0, this.row_buf, 1, this.width * this.row_info.pixel_depth + 7 >> 3);
            return;
        }
        switch (this.row_info.pixel_depth) {
            case 1: {
                int n2 = 1;
                int n3 = 0;
                int n4 = 7;
                int n5 = 128;
                int n6 = 0;
                while (n6 < this.width) {
                    if ((n5 & n) != 0) {
                        int n7 = this.row_buf[n2] >> n4 & 1;
                        int n8 = n3;
                        byArray[n8] = (byte)(byArray[n8] & (byte)(32639 >> 7 - n4 & 0xFF));
                        int n9 = n3;
                        byArray[n9] = (byte)(byArray[n9] | (byte)(n7 << n4));
                    }
                    if (n4 == 0) {
                        n4 = 7;
                        ++n2;
                        ++n3;
                    } else {
                        --n4;
                    }
                    n5 = n5 == 1 ? 128 : (n5 >>= 1);
                    ++n6;
                }
                return;
            }
            case 2: {
                int n10 = 1;
                int n11 = 0;
                int n12 = 6;
                int n13 = 128;
                int n14 = 0;
                while (n14 < this.width) {
                    if ((n13 & n) != 0) {
                        int n15 = this.row_buf[n10] >> n12 & 3;
                        int n16 = n11;
                        byArray[n16] = (byte)(byArray[n16] & (byte)(16191 >> 6 - n12 & 0xFF));
                        int n17 = n11;
                        byArray[n17] = (byte)(byArray[n17] | (byte)(n15 << n12));
                    }
                    if (n12 == 0) {
                        n12 = 6;
                        ++n10;
                        ++n11;
                    } else {
                        n12 -= 2;
                    }
                    n13 = n13 == 1 ? 128 : (n13 >>= 1);
                    ++n14;
                }
                return;
            }
            case 4: {
                int n18 = 1;
                int n19 = 0;
                int n20 = 4;
                int n21 = 128;
                int n22 = 0;
                while (n22 < this.width) {
                    if ((n21 & n) != 0) {
                        int n23 = this.row_buf[n18] >> n20 & 0xF;
                        int n24 = n19;
                        byArray[n24] = (byte)(byArray[n24] & (byte)(3855 >> 4 - n20 & 0xFF));
                        int n25 = n19;
                        byArray[n25] = (byte)(byArray[n25] | (byte)(n23 << n20));
                    }
                    if (n20 == 0) {
                        n20 = 4;
                        ++n18;
                        ++n19;
                    } else {
                        n20 -= 4;
                    }
                    n21 = n21 == 1 ? 128 : (n21 >>= 1);
                    ++n22;
                }
                return;
            }
        }
        int n26 = this.row_info.pixel_depth >> 3;
        int n27 = 1;
        int n28 = 0;
        int n29 = -128;
        int n30 = 0;
        while (n30 < this.width) {
            if ((n29 & n) != 0) {
                this.memCopy(byArray, n28, this.row_buf, n27, n26);
            }
            n27 += n26;
            n28 += n26;
            n29 = n29 == 1 ? -128 : (int)((byte)(n29 >> 1));
            ++n30;
        }
    }

    private void crcRead(byte[] byArray, int n) throws IOException {
        boolean bl = true;
        if ((this.chunk_name[0] & 0x20) != 0) {
            if ((this.flags & 0x300) == 768) {
                bl = false;
            }
        } else if ((this.flags & 0x800) != 0) {
            bl = false;
        }
        this.readData(byArray, n);
        if (bl) {
            this.calculateCRC(byArray, n);
        }
    }

    private int crcFinish(int n) throws PNGException, IOException {
        boolean bl = true;
        if ((this.chunk_name[0] & 0x20) != 0) {
            if ((this.flags & 0x300) == 768) {
                bl = false;
            }
        } else if ((this.flags & 0x800) != 0) {
            bl = false;
        }
        int n2 = n;
        while (n2 > this.zbuf_size) {
            this.readData(this.zbuf, this.zbuf_size);
            if (bl) {
                this.calculateCRC(this.zbuf, this.zbuf_size);
            }
            n2 -= this.zbuf_size;
        }
        if (n2 != 0) {
            this.readData(this.zbuf, n2);
            if (bl) {
                this.calculateCRC(this.zbuf, n2);
            }
        }
        int n3 = this.crcError();
        if (bl && n3 != 0) {
            String string = "CRC error in " + this.chunk_name;
            if (!((this.chunk_name[0] & 0x20) != 0 && (this.flags & 0x200) == 0 || (this.chunk_name[0] & 0x20) == 0 && (this.flags & 0x400) != 0)) {
                throw new PNGException(string);
            }
            this.warning(string);
            return 1;
        }
        return 0;
    }

    private int crcError() throws IOException {
        byte[] byArray = new byte[4];
        this.readData(byArray, 4);
        int n = this.getInt32(byArray);
        if (n != this.crc) {
            return 1;
        }
        return 0;
    }

    protected void readData(byte[] byArray, int n) throws IOException {
        int n2 = this.png_istream.read(byArray, 0, n);
        if (n2 != n) {
            throw new PNGException("Read Error");
        }
    }
}

