/*
 * Decompiled with CFR 0.152.
 */
import com.pearsoneduc.ip.gui.ImageView;
import com.pearsoneduc.ip.gui.WindowMonitor;
import com.pearsoneduc.ip.io.ImageDecoder;
import com.pearsoneduc.ip.io.ImageDecoderException;
import com.pearsoneduc.ip.io.ImageFile;
import com.pearsoneduc.ip.op.FFTException;
import com.pearsoneduc.ip.op.ImageFFT;
import com.pearsoneduc.ip.util.StringTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class SpectrumViewer
extends JFrame {
    private int width;
    private int height;
    private ImageFFT fft;
    private BufferedImage shiftedSpectrum;
    private BufferedImage unshiftedSpectrum;
    private boolean shifted;
    private ImageView spectrumView;
    private Info infoPane;

    public SpectrumViewer(String string, int n) throws IOException, ImageDecoderException, FFTException {
        super("SpectrumViewer");
        ImageDecoder imageDecoder = ImageFile.createImageDecoder((String)string);
        BufferedImage bufferedImage = imageDecoder.decodeAsBufferedImage();
        System.out.println("Computing FFT and spectra...");
        this.fft = new ImageFFT(bufferedImage, n);
        this.width = this.fft.getWidth();
        this.height = this.fft.getHeight();
        this.fft.transform();
        this.shiftedSpectrum = this.fft.getSpectrum();
        this.unshiftedSpectrum = this.fft.getUnshiftedSpectrum();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(new JScrollPane((Component)new ImageView(bufferedImage)));
        this.spectrumView = new ImageView(this.unshiftedSpectrum);
        this.shifted = false;
        jPanel.add(new Scroller(this.spectrumView));
        this.infoPane = new Info();
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new Buttons());
        jPanel2.add(this.infoPane);
        Container container = this.getContentPane();
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel2, "South");
        this.addWindowListener((WindowListener)new WindowMonitor());
    }

    static /* synthetic */ Info access$0(SpectrumViewer spectrumViewer) {
        return spectrumViewer.infoPane;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            try {
                int n = 1;
                if (stringArray.length > 1) {
                    n = Integer.parseInt(stringArray[1]);
                }
                SpectrumViewer spectrumViewer = new SpectrumViewer(stringArray[0], n);
                spectrumViewer.pack();
                ((Component)spectrumViewer).setVisible(true);
            }
            catch (Exception exception) {
                System.err.println(exception);
                System.exit(1);
            }
        } else {
            System.err.println("usage: java SpectrumViewer <imagefile> [<window>]");
            System.exit(1);
        }
    }

    class Scroller
    extends JScrollPane {
        public Scroller(ImageView imageView) {
            super((Component)imageView);
            this.addMouseMotionListener(new MouseMotionAdapter(this){
                private final /* synthetic */ Scroller this$1;
                {
                    this.this$1 = scroller;
                }

                public void mouseMoved(MouseEvent mouseEvent) {
                    SpectrumViewer.access$0(Scroller.access$0(this.this$1)).updateInfo(this.this$1.getPixelCoordinates(mouseEvent.getPoint()));
                }
            });
        }

        static /* synthetic */ SpectrumViewer access$0(Scroller scroller) {
            return scroller.SpectrumViewer.this;
        }

        public Point getPixelCoordinates(Point point) {
            Point point2 = this.getViewport().getViewPosition();
            Point point3 = new Point(point2.x + point.x, point2.y + point.y);
            return point3;
        }
    }

    class Info
    extends JPanel {
        private int w2;
        private int h2;
        private NumberFormat magFormat;
        private NumberFormat phaseFormat;
        private JLabel uCoord = new JLabel();
        private JLabel vCoord = new JLabel();
        private JLabel magnitude = new JLabel();
        private JLabel phase = new JLabel();

        public Info() {
            this.w2 = SpectrumViewer.this.width / 2;
            this.h2 = SpectrumViewer.this.height / 2;
            this.magFormat = new DecimalFormat("0.000000E0");
            this.phaseFormat = new DecimalFormat("0.000");
            JPanel jPanel = new JPanel();
            jPanel.add(new JLabel("u"));
            Font font = new Font("Monospaced", 1, 12);
            this.uCoord.setFont(font);
            this.uCoord.setForeground(Color.black);
            jPanel.add(this.uCoord);
            jPanel.add(new JLabel(" v"));
            this.vCoord.setFont(font);
            this.vCoord.setForeground(Color.black);
            jPanel.add(this.vCoord);
            jPanel.setBorder(BorderFactory.createEtchedBorder());
            this.add(jPanel);
            JPanel jPanel2 = new JPanel();
            jPanel2.add(new JLabel("magnitude"));
            this.magnitude.setFont(font);
            this.magnitude.setForeground(Color.black);
            jPanel2.add(this.magnitude);
            jPanel2.add(new JLabel(" phase"));
            this.phase.setFont(font);
            this.phase.setForeground(Color.black);
            jPanel2.add(this.phase);
            jPanel2.setBorder(BorderFactory.createEtchedBorder());
            this.add(jPanel2);
            this.updateInfo(new Point(0, 0));
        }

        public void updateInfo(Point point) {
            block4: {
                if (!this.validPoint(point)) break block4;
                try {
                    int n;
                    int n2;
                    if (SpectrumViewer.this.shifted) {
                        n2 = point.x >= this.w2 ? point.x - this.w2 : point.x + this.w2;
                        n = point.y >= this.h2 ? point.y - this.h2 : point.y + this.h2;
                        this.uCoord.setText(StringTools.rightJustify((int)(point.x - this.w2), (int)4));
                        this.vCoord.setText(StringTools.rightJustify((int)(point.y - this.h2), (int)4));
                    } else {
                        n2 = point.x;
                        n = point.y;
                        this.uCoord.setText(StringTools.rightJustify((int)n2, (int)4));
                        this.vCoord.setText(StringTools.rightJustify((int)n, (int)4));
                    }
                    this.magnitude.setText(StringTools.rightJustify((String)this.magFormat.format(SpectrumViewer.this.fft.getMagnitude(n2, n)), (int)10));
                    this.phase.setText(StringTools.rightJustify((String)this.phaseFormat.format(SpectrumViewer.this.fft.getPhase(n2, n)), (int)6));
                }
                catch (Exception exception) {}
            }
        }

        public boolean validPoint(Point point) {
            return point.x >= 0 && point.x < SpectrumViewer.this.width && point.y >= 0 && point.y < SpectrumViewer.this.height;
        }
    }

    class Buttons
    extends JPanel
    implements ActionListener {
        public Buttons() {
            ButtonGroup buttonGroup = new ButtonGroup();
            JRadioButton jRadioButton = new JRadioButton("shifted");
            jRadioButton.addActionListener(this);
            buttonGroup.add(jRadioButton);
            this.add(jRadioButton);
            jRadioButton = new JRadioButton("unshifted");
            jRadioButton.setSelected(true);
            jRadioButton.addActionListener(this);
            buttonGroup.add(jRadioButton);
            this.add(jRadioButton);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (!SpectrumViewer.this.shifted && string.equals("shifted")) {
                SpectrumViewer.this.spectrumView.setImage(SpectrumViewer.this.shiftedSpectrum);
                SpectrumViewer.this.spectrumView.repaint();
                SpectrumViewer.this.shifted = true;
            } else if (SpectrumViewer.this.shifted && string.equals("unshifted")) {
                SpectrumViewer.this.spectrumView.setImage(SpectrumViewer.this.unshiftedSpectrum);
                SpectrumViewer.this.spectrumView.repaint();
                SpectrumViewer.this.shifted = false;
            }
        }
    }
}

