/*
 * Decompiled with CFR 0.152.
 */
import com.pearsoneduc.ip.gui.ViewWithROI;
import com.pearsoneduc.ip.gui.WindowMonitor;
import com.pearsoneduc.ip.io.ImageDecoder;
import com.pearsoneduc.ip.io.ImageDecoderException;
import com.pearsoneduc.ip.io.ImageFile;
import com.pearsoneduc.ip.op.FFTException;
import com.pearsoneduc.ip.op.ImageFFT;
import com.pearsoneduc.ip.op.OperationException;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SpectralProbe
extends JFrame {
    private BufferedImage image;
    private Rectangle imageArea;
    private ViewWithROI imageView;
    private Point centre = new Point();
    private Rectangle region = new Rectangle();
    private int window = 1;
    private JLabel spectrumView;

    public SpectralProbe(String string) throws IOException, ImageDecoderException, OperationException {
        super("SpectralProbe: " + string);
        ImageDecoder imageDecoder = ImageFile.createImageDecoder((String)string);
        this.image = imageDecoder.decodeAsBufferedImage();
        if (this.image.getType() != 10) {
            throw new OperationException("image must be 8-bit greyscale");
        }
        this.imageArea = new Rectangle(0, 0, this.image.getWidth(), this.image.getHeight());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        this.imageView = new ViewWithROI(this.image);
        this.centre.x = this.image.getWidth() / 2;
        this.centre.y = this.image.getHeight() / 2;
        this.region.x = this.centre.x - 8;
        this.region.y = this.centre.y - 8;
        this.region.height = 16;
        this.region.width = 16;
        this.imageView.setROI(this.region);
        jPanel.add(new Display());
        this.spectrumView = new JLabel(this.getRegionSpectrum());
        jPanel.add(this.spectrumView);
        Container container = this.getContentPane();
        container.add((Component)jPanel, "Center");
        container.add((Component)new Controls(), "South");
        this.addWindowListener((WindowListener)new WindowMonitor());
    }

    public void changeRegion(int n) {
        int n2 = this.centre.x - n / 2;
        int n3 = this.centre.y - n / 2;
        if (this.imageArea.contains(n2, n3) && this.imageArea.contains(n2 + n - 1, n3 + n - 1)) {
            this.region.x = n2;
            this.region.y = n3;
            this.region.width = this.region.height = n;
            this.imageView.setROI(this.region);
            this.spectrumView.setIcon(this.getRegionSpectrum());
        }
    }

    public void changeRegion(Point point) {
        int n = point.x - this.region.width / 2;
        int n2 = point.y - this.region.height / 2;
        if (this.imageArea.contains(n, n2) && this.imageArea.contains(n + this.region.width - 1, n2 + this.region.height - 1)) {
            this.centre = point;
            this.region.x = n;
            this.region.y = n2;
            this.imageView.setROI(this.region);
            this.spectrumView.setIcon(this.getRegionSpectrum());
        }
    }

    public ImageIcon getRegionSpectrum() {
        BufferedImage bufferedImage = this.image.getSubimage(this.region.x, this.region.y, this.region.width, this.region.height);
        try {
            ImageFFT imageFFT = new ImageFFT(bufferedImage, this.window);
            imageFFT.transform();
            Image image = imageFFT.getSpectrum().getScaledInstance(128, 128, 2);
            return new ImageIcon(image);
        }
        catch (FFTException fFTException) {
            return null;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            try {
                SpectralProbe spectralProbe = new SpectralProbe(stringArray[0]);
                spectralProbe.pack();
                ((Component)spectralProbe).setVisible(true);
            }
            catch (Exception exception) {
                System.err.println(exception);
                System.exit(1);
            }
        } else {
            System.err.println("usage: java SpectralProbe <imagefile>");
            System.exit(1);
        }
    }

    class Display
    extends JPanel {
        public Display() {
            this.add((Component)SpectralProbe.this.imageView);
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ Display this$1;
                {
                    this.this$1 = display;
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    Display.access$0(this.this$1).changeRegion(mouseEvent.getPoint());
                }
            });
        }

        static /* synthetic */ SpectralProbe access$0(Display display) {
            return display.SpectralProbe.this;
        }
    }

    class Controls
    extends JPanel
    implements ActionListener {
        private JComboBox sizeSelector = new JComboBox();
        private JComboBox windowSelector = new JComboBox();

        public Controls() {
            this.add(new JLabel("Region size "));
            String[] stringArray = new String[]{"16", "32", "64"};
            int n = 0;
            while (n < stringArray.length) {
                this.sizeSelector.addItem(stringArray[n]);
                ++n;
            }
            this.sizeSelector.addActionListener(this);
            this.add(this.sizeSelector);
            this.add(new JLabel(" Window "));
            String[] stringArray2 = new String[]{"none", "Bartlett", "Hamming", "Hanning"};
            int n2 = 0;
            while (n2 < stringArray2.length) {
                this.windowSelector.addItem(stringArray2[n2]);
                ++n2;
            }
            this.windowSelector.addActionListener(this);
            this.add(this.windowSelector);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)((JComboBox)actionEvent.getSource()).getSelectedItem();
            if (string.equals("16") || string.equals("32") || string.equals("64")) {
                int n = Integer.parseInt(string);
                SpectralProbe.this.changeRegion(n);
            } else if (string.equals("none") && SpectralProbe.this.window != 1) {
                SpectralProbe.this.window = 1;
                SpectralProbe.this.spectrumView.setIcon(SpectralProbe.this.getRegionSpectrum());
            } else if (string.equals("Bartlett") && SpectralProbe.this.window != 2) {
                SpectralProbe.this.window = 2;
                SpectralProbe.this.spectrumView.setIcon(SpectralProbe.this.getRegionSpectrum());
            } else if (string.equals("Hamming") && SpectralProbe.this.window != 3) {
                SpectralProbe.this.window = 3;
                SpectralProbe.this.spectrumView.setIcon(SpectralProbe.this.getRegionSpectrum());
            } else if (string.equals("Hanning") && SpectralProbe.this.window != 4) {
                SpectralProbe.this.window = 4;
                SpectralProbe.this.spectrumView.setIcon(SpectralProbe.this.getRegionSpectrum());
            }
        }
    }
}

