/*
 * Decompiled with CFR 0.152.
 */
import com.pearsoneduc.ip.gui.WindowMonitor;
import com.pearsoneduc.ip.io.ImageDecoder;
import com.pearsoneduc.ip.io.ImageDecoderException;
import com.pearsoneduc.ip.io.ImageEncoder;
import com.pearsoneduc.ip.io.ImageEncoderException;
import com.pearsoneduc.ip.io.ImageFile;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class LogPolar
extends JFrame
implements ActionListener {
    private BufferedImage sourceImage;
    private BufferedImage logPolarImage;
    private Rectangle imageRect;
    private int numSectors;
    private int numRings;
    private float cx;
    private float cy;
    private float dr;
    private float dtheta;
    private float[] ctheta;
    private float[] stheta;
    private JLabel view;
    private LogPolarInfo info = new LogPolarInfo();
    private JFileChooser fileChooser = new JFileChooser(System.getProperty("user.dir"));

    public LogPolar(String string, int n, int n2) throws IOException, ImageDecoderException {
        super("LogPolar: " + string);
        this.readImage(string);
        this.numSectors = n;
        this.numRings = n2;
        this.computeMappingParameters();
        this.logPolarImage = this.createLogPolarImage();
        this.view = new JLabel(new ImageIcon(this.logPolarImage));
        this.view.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                float f = LogPolar.this.dr * (float)point.y;
                int n = Math.round(LogPolar.this.cx + f * LogPolar.this.ctheta[point.x]);
                int n2 = Math.round(LogPolar.this.cy + f * LogPolar.this.stheta[point.x]);
                if (LogPolar.this.imageRect.contains(n, n2)) {
                    float f2 = LogPolar.this.dtheta * (float)point.x;
                    LogPolar.this.info.display(f, f2, n, n2);
                } else {
                    LogPolar.this.info.clearDisplay();
                }
            }
        });
        Container container = this.getContentPane();
        container.add((Component)this.view, "Center");
        container.add((Component)this.info, "South");
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('F');
        JMenuItem jMenuItem = new JMenuItem("Save image", 83);
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Exit", 88);
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        this.fileChooser.setDialogTitle("Save image");
        this.addWindowListener((WindowListener)new WindowMonitor());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Save image")) {
            this.saveImage();
            this.repaint();
        } else if (string.equals("Exit")) {
            ((Component)this).setVisible(false);
            this.dispose();
            System.exit(0);
        }
    }

    public void computeMappingParameters() {
        this.imageRect = new Rectangle(this.sourceImage.getWidth(), this.sourceImage.getHeight());
        this.cx = (float)this.sourceImage.getWidth() / 2.0f;
        this.cy = (float)this.sourceImage.getHeight() / 2.0f;
        this.dr = (float)(Math.sqrt(this.cx * this.cx + this.cy * this.cy) / (double)this.numRings);
        this.dtheta = 360.0f / (float)this.numSectors;
        this.ctheta = new float[this.numSectors];
        this.stheta = new float[this.numSectors];
        double d = 0.0;
        double d2 = (double)this.dtheta * (Math.PI / 180);
        int n = 0;
        while (n < this.numSectors) {
            this.ctheta[n] = (float)Math.cos(d);
            this.stheta[n] = (float)Math.sin(d);
            ++n;
            d += d2;
        }
    }

    public BufferedImage createLogPolarImage() {
        BufferedImage bufferedImage = new BufferedImage(this.numSectors, this.numRings, this.sourceImage.getType());
        int n = this.sourceImage.getRGB(Math.round(this.cx), Math.round(this.cy));
        int n2 = 0;
        while (n2 < this.numSectors) {
            bufferedImage.setRGB(n2, 0, n);
            ++n2;
        }
        float f = this.dr;
        int n3 = 1;
        while (n3 < this.numRings) {
            int n4 = 0;
            while (n4 < this.numSectors) {
                int n5;
                int n6 = Math.round(this.cx + f * this.ctheta[n4]);
                if (this.imageRect.contains(n6, n5 = Math.round(this.cy + f * this.stheta[n4]))) {
                    bufferedImage.setRGB(n4, n3, this.sourceImage.getRGB(n6, n5));
                } else {
                    bufferedImage.setRGB(n4, n3, 0);
                }
                ++n4;
            }
            ++n3;
            f += this.dr;
        }
        return bufferedImage;
    }

    public void error(String string) {
        JOptionPane.showMessageDialog(this, string, "Error", 0);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 2) {
            try {
                int n = Integer.parseInt(stringArray[1]);
                int n2 = Integer.parseInt(stringArray[2]);
                LogPolar logPolar = new LogPolar(stringArray[0], n, n2);
                logPolar.pack();
                ((Component)logPolar).setVisible(true);
            }
            catch (Exception exception) {
                System.err.println(exception);
                System.exit(1);
            }
        } else {
            System.err.println("usage: java LogPolar <imagefile> <sectors> <rings>");
            System.exit(1);
        }
    }

    public void readImage(String string) throws IOException, ImageDecoderException {
        ImageDecoder imageDecoder = ImageFile.createImageDecoder((String)string);
        this.sourceImage = imageDecoder.decodeAsBufferedImage();
    }

    public void saveImage() {
        block4: {
            if (this.fileChooser.showSaveDialog(this) != 0) break block4;
            try {
                int n;
                File file = this.fileChooser.getSelectedFile();
                if (file.exists() && (n = JOptionPane.showConfirmDialog(this, "File will be overwritten!  Are you sure?", "File exists", 2)) != 0) {
                    return;
                }
                ImageEncoder imageEncoder = ImageFile.createImageEncoder((String)file.getAbsolutePath());
                imageEncoder.encode(this.logPolarImage);
                this.fileChooser.rescanCurrentDirectory();
            }
            catch (ImageEncoderException imageEncoderException) {
                this.error("Cannot determine an appropriate image format!");
            }
            catch (IOException iOException) {
                this.error("Error writing image!");
            }
        }
    }
}

