/*
 * Decompiled with CFR 0.152.
 */
package com.visualtek.PNG;

import com.visualtek.PNG.PNGData;
import com.visualtek.PNG.PNGDataDecoder;
import com.visualtek.PNG.PNGException;
import com.visualtek.PNG.PNGInfo;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public class PNGProducer
implements ImageProducer {
    public int width;
    public int height;
    public int[] pixels;
    private ColorModel colorModel = ColorModel.getRGBdefault();
    private ImageConsumer theConsumer;
    private boolean initialised = false;

    public PNGProducer() throws PNGException, IOException {
        this.initialised = false;
    }

    public PNGProducer(InputStream inputStream) throws PNGException, IOException {
        this.init(inputStream);
        this.initialised = true;
    }

    public void init(InputStream inputStream) throws PNGException, IOException {
        PNGDataDecoder pNGDataDecoder = new PNGDataDecoder(inputStream);
        PNGInfo pNGInfo = new PNGInfo();
        PNGInfo pNGInfo2 = new PNGInfo();
        pNGDataDecoder.readInfo(pNGInfo);
        this.width = pNGInfo.width;
        this.height = pNGInfo.height;
        this.pixels = new int[this.width * this.height];
        int n = 0;
        int n2 = 3;
        if ((pNGInfo.color_type & 3) == 3) {
            n2 = 1;
        }
        if ((pNGInfo.color_type & 4) != 0) {
            ++n2;
        }
        byte[] byArray = new byte[pNGInfo.rowbytes];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < this.height) {
            pNGDataDecoder.readRow(byArray);
            int n7 = 0;
            int n8 = 0;
            while (n8 < this.width) {
                if (n2 >= 3) {
                    n3 = PNGData.ubyte(byArray[n7]);
                    n4 = PNGData.ubyte(byArray[n7 + 1]);
                    n5 = PNGData.ubyte(byArray[n7 + 2]);
                } else {
                    int n9 = PNGData.ubyte(byArray[n7]);
                    n3 = pNGInfo.palette[n9].getRed();
                    n4 = pNGInfo.palette[n9].getGreen();
                    n5 = pNGInfo.palette[n9].getBlue();
                }
                this.pixels[n++] = 0xFF000000 | n3 << 16 | n4 << 8 | n5;
                ++n8;
                n7 += n2;
            }
            ++n6;
        }
        pNGDataDecoder.readEnd(pNGInfo2);
    }

    public synchronized void addConsumer(ImageConsumer imageConsumer) {
        this.theConsumer = imageConsumer;
        this.produce();
        this.theConsumer = null;
    }

    public synchronized boolean isConsumer(ImageConsumer imageConsumer) {
        return imageConsumer == this.theConsumer;
    }

    public synchronized void removeConsumer(ImageConsumer imageConsumer) {
        if (this.theConsumer == imageConsumer) {
            this.theConsumer = null;
        }
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer);
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    private void produce() {
        if (this.theConsumer != null) {
            this.theConsumer.setDimensions(this.width, this.height);
        }
        if (this.theConsumer != null) {
            this.theConsumer.setProperties(new Hashtable());
        }
        if (this.theConsumer != null) {
            this.theConsumer.setColorModel(this.colorModel);
        }
        if (this.theConsumer != null) {
            this.theConsumer.setHints(30);
        }
        if (this.theConsumer != null) {
            this.theConsumer.setPixels(0, 0, this.width, this.height, this.colorModel, this.pixels, 0, this.width);
        }
        if (this.theConsumer != null) {
            this.theConsumer.imageComplete(3);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof InputStream) {
            if (!this.initialised) {
                try {
                    this.init((InputStream)object);
                    this.initialised = true;
                }
                catch (Exception exception) {}
            }
            return false;
        }
        return super.equals(object);
    }
}

