/*
 * Decompiled with CFR 0.152.
 */
import com.pearsoneduc.ip.gui.ImageView;
import com.pearsoneduc.ip.gui.WindowMonitor;
import com.pearsoneduc.ip.io.ImageDecoder;
import com.pearsoneduc.ip.io.ImageDecoderException;
import com.pearsoneduc.ip.io.ImageFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AffineTransformTool
extends JFrame {
    private BufferedImage image;
    private ImageView transformedView;

    public AffineTransformTool(String string) throws IOException, ImageDecoderException {
        super("AffineTransformTool: " + string);
        ImageDecoder imageDecoder = ImageFile.createImageDecoder((String)string);
        this.image = imageDecoder.decodeAsBufferedImage();
        ImageView imageView = new ImageView(this.image);
        this.transformedView = new ImageView(this.image);
        JPanel jPanel = new JPanel();
        jPanel.add(new JScrollPane((Component)imageView));
        jPanel.add(new JScrollPane((Component)this.transformedView));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        jPanel2.add((Component)new Controls(), "South");
        this.setContentPane(jPanel2);
        this.addWindowListener((WindowListener)new WindowMonitor());
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            try {
                AffineTransformTool affineTransformTool = new AffineTransformTool(stringArray[0]);
                affineTransformTool.pack();
                ((Component)affineTransformTool).setVisible(true);
            }
            catch (Exception exception) {
                System.err.println(exception);
                System.exit(1);
            }
        } else {
            System.err.println("usage: java AffineTransformTool <imagefile>");
            System.exit(1);
        }
    }

    class Controls
    extends JPanel
    implements ChangeListener,
    ActionListener {
        private Font labelFont = new Font("Monospaced", 1, 12);
        private JSlider xScale = new JSlider(1, 20, 10);
        private JSlider yScale = new JSlider(1, 20, 10);
        private JSlider angle = new JSlider(-90, 90, 0);
        private JRadioButton zeroOrder = new JRadioButton("zero-order");
        private JRadioButton firstOrder = new JRadioButton("first-order");
        private int interpolation = 1;

        public Controls() {
            this.setLayout(new GridLayout(0, 1));
            this.addSlider(this.xScale, "horizontal scale (x10) ", 0, 1, 5, 5);
            this.addSlider(this.yScale, "  vertical scale (x10) ", 0, 1, 5, 5);
            this.addSlider(this.angle, "              rotation ", 30, 5, 30, -90);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.zeroOrder);
            buttonGroup.add(this.firstOrder);
            this.zeroOrder.setSelected(true);
            this.zeroOrder.addActionListener(this);
            this.firstOrder.addActionListener(this);
            JPanel jPanel = new JPanel();
            jPanel.add(this.zeroOrder);
            jPanel.add(this.firstOrder);
            this.add(jPanel);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.startsWith("zero") && this.interpolation == 2) {
                this.interpolation = 1;
                this.transformImage();
            } else if (string.startsWith("first") && this.interpolation == 1) {
                this.interpolation = 2;
                this.transformImage();
            }
        }

        public void addSlider(JSlider jSlider, String string, int n, int n2, int n3, int n4) {
            JPanel jPanel = new JPanel();
            JLabel jLabel = new JLabel(string);
            jLabel.setFont(this.labelFont);
            jPanel.add(jLabel);
            jSlider.setMajorTickSpacing(n);
            jSlider.setMinorTickSpacing(n2);
            jSlider.setPaintTicks(true);
            jSlider.setPaintLabels(true);
            jSlider.setLabelTable(jSlider.createStandardLabels(n3, n4));
            jSlider.addChangeListener(this);
            jPanel.add(jSlider);
            this.add(jPanel);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            if (!jSlider.getValueIsAdjusting()) {
                this.transformImage();
            }
        }

        public void transformImage() {
            double d = (double)this.xScale.getValue() / 10.0;
            double d2 = (double)this.yScale.getValue() / 10.0;
            double d3 = (double)this.angle.getValue() * Math.PI / 180.0;
            AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d2);
            affineTransform.rotate(d3);
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, this.interpolation);
            AffineTransformTool.this.transformedView.setImage(affineTransformOp.filter(AffineTransformTool.this.image, null));
            AffineTransformTool.this.transformedView.repaint();
        }
    }
}

