/*
 * Decompiled with CFR 0.152.
 */
import com.pearsoneduc.ip.op.Histogram;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JLabel;

public class HistogramView
extends JLabel {
    private static final int HIST_WIDTH = 296;
    private static final int HIST_HEIGHT = 140;
    private static final int TICK_INTERVAL = 50;
    private static final int TICK_SIZE = 4;
    private Histogram histogram;
    private int band;
    private int xOrigin = 20;
    private int ySize = 100;
    private int yOrigin = this.ySize + 10;
    private Color histColor;
    private HistogramInfoPane infoPane;

    public HistogramView(Histogram histogram) {
        this(histogram, 0);
    }

    public HistogramView(Histogram histogram, int n) {
        this(histogram, n, null);
    }

    public HistogramView(Histogram histogram, int n, HistogramInfoPane histogramInfoPane) {
        this.histogram = histogram;
        this.band = n;
        this.infoPane = histogramInfoPane;
        this.setPreferredSize(new Dimension(296, 140));
        if (this.infoPane != null) {
            this.addMouseMotionListener(new MouseMotionAdapter(){

                public void mouseMoved(MouseEvent mouseEvent) {
                    HistogramView.this.infoPane.updateInfo(HistogramView.this.band, HistogramView.this.getValue(mouseEvent.getPoint()));
                }
            });
        }
    }

    public HistogramView(Histogram histogram, HistogramInfoPane histogramInfoPane) {
        this(histogram, 0, histogramInfoPane);
    }

    public void drawAxis(Graphics graphics, int n, int n2) {
        Color color = graphics.getColor();
        graphics.setColor(Color.black);
        graphics.drawLine(n, n2, n + 255, n2);
        int n3 = 0;
        while (n3 < 256) {
            graphics.drawLine(n + n3, n2, n + n3, n2 + 4);
            this.drawTickLabel(graphics, String.valueOf(n3), n + n3, n2 + 4 + 2);
            n3 += 50;
        }
        graphics.setColor(color);
    }

    public void drawTickLabel(Graphics graphics, String string, int n, int n2) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle rectangle = (Rectangle)fontMetrics.getStringBounds(string, graphics);
        graphics.drawString(string, n - rectangle.width / 2, n2 + rectangle.height);
    }

    public int getValue(Point point) {
        return Math.min(Math.max(point.x - this.xOrigin, 0), 255);
    }

    public void paintComponent(Graphics graphics) {
        double d = (double)this.ySize / (double)this.histogram.getMaxFrequency(this.band);
        if (this.histColor != null) {
            graphics.setColor(this.histColor);
        }
        int n = 0;
        while (n < 256) {
            int n2 = (int)Math.round(d * (double)this.histogram.getFrequency(this.band, n));
            if (n2 > 0) {
                graphics.drawLine(n + this.xOrigin, this.yOrigin, n + this.xOrigin, this.yOrigin - n2);
            }
            ++n;
        }
        this.drawAxis(graphics, this.xOrigin, this.yOrigin + 1);
    }

    public void setColor(Color color) {
        this.histColor = color;
    }

    public void setHistogram(Histogram histogram) {
        this.setHistogram(histogram, 0);
    }

    public void setHistogram(Histogram histogram, int n) {
        this.histogram = histogram;
        this.band = n;
        this.repaint();
    }
}

