/*
 * Decompiled with CFR 0.152.
 */
import com.pearsoneduc.ip.gui.WindowMonitor;
import com.pearsoneduc.ip.io.ImageDecoder;
import com.pearsoneduc.ip.io.ImageDecoderException;
import com.pearsoneduc.ip.io.ImageFile;
import com.pearsoneduc.ip.op.Histogram;
import com.pearsoneduc.ip.op.HistogramException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.BevelBorder;

public class HistogramTool
extends JFrame
implements ActionListener {
    private Histogram histogram;
    private HistogramView[] view;
    private HistogramInfoPane infoPane;
    private JPanel mainPane;
    private JMenu menu;
    private JFileChooser fileChooser = new JFileChooser(System.getProperty("user.dir"));

    public HistogramTool(Histogram histogram, String string) {
        super(string);
        this.histogram = histogram;
        this.infoPane = new HistogramInfoPane(this.histogram);
        this.mainPane = new JPanel(new BorderLayout());
        if (this.histogram.getNumBands() == 3) {
            this.createMultipleViews();
        } else {
            this.createSingleView();
        }
        this.mainPane.add((Component)this.infoPane, "South");
        this.setContentPane(this.mainPane);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.setBorder(new BevelBorder(0));
        this.createFileMenu();
        jMenuBar.add(this.menu);
        this.setJMenuBar(jMenuBar);
        this.addWindowListener((WindowListener)new WindowMonitor());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.startsWith("Load")) {
            this.loadImage();
            this.repaint();
        } else if (string.startsWith("Save")) {
            this.saveHistogram();
            this.repaint();
        } else if (string.equals("Exit")) {
            ((Component)this).setVisible(false);
            this.dispose();
            System.exit(0);
        }
    }

    public void createFileMenu() {
        this.menu = new JMenu("File");
        this.menu.setMnemonic('F');
        String[] stringArray = new String[]{"Load image", "Save histogram", "Exit"};
        char[] cArray = new char[]{'L', 'S', 'X'};
        int n = 0;
        while (n < 3) {
            JMenuItem jMenuItem = new JMenuItem(stringArray[n], cArray[n]);
            jMenuItem.addActionListener(this);
            this.menu.add(jMenuItem);
            ++n;
        }
    }

    public void createMultipleViews() {
        this.view = new HistogramView[3];
        Color[] colorArray = new Color[]{Color.red, Color.green, Color.blue};
        String[] stringArray = new String[]{"Red", "Green", "Blue"};
        JTabbedPane jTabbedPane = new JTabbedPane(3);
        int n = 0;
        while (n < 3) {
            this.view[n] = new HistogramView(this.histogram, n, this.infoPane);
            this.view[n].setColor(colorArray[n]);
            jTabbedPane.add(stringArray[n], this.view[n]);
            ++n;
        }
        this.mainPane.add((Component)jTabbedPane, "Center");
    }

    public void createSingleView() {
        this.view = new HistogramView[1];
        this.view[0] = new HistogramView(this.histogram, this.infoPane);
        this.mainPane.add((Component)this.view[0], "Center");
    }

    public void error(String string) {
        JOptionPane.showMessageDialog(this, string, "Error", 0);
    }

    public void loadImage() {
        this.fileChooser.setDialogTitle("Load image");
        if (this.fileChooser.showOpenDialog(this) == 0) {
            try {
                File file = this.fileChooser.getSelectedFile();
                ImageDecoder imageDecoder = ImageFile.createImageDecoder((String)file.getAbsolutePath());
                BufferedImage bufferedImage = imageDecoder.decodeAsBufferedImage();
                this.histogram.computeHistogram(bufferedImage);
                this.setTitle(file.getName());
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.error("File not found.");
                return;
            }
            catch (ImageDecoderException imageDecoderException) {
                this.error("Cannot read this image format.");
                return;
            }
            catch (IOException iOException) {
                this.error("Failed to read image data.");
                return;
            }
            catch (HistogramException histogramException) {
                this.error("Cannot compute histogram for this image type.");
                return;
            }
            this.mainPane.removeAll();
            if (this.histogram.getNumBands() == 3) {
                this.createMultipleViews();
            } else {
                this.createSingleView();
            }
            this.mainPane.add((Component)this.infoPane, "South");
            this.mainPane.invalidate();
            this.validate();
            this.pack();
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            try {
                ImageDecoder imageDecoder = ImageFile.createImageDecoder((String)stringArray[0]);
                BufferedImage bufferedImage = imageDecoder.decodeAsBufferedImage();
                Histogram histogram = new Histogram(bufferedImage);
                HistogramTool histogramTool = new HistogramTool(histogram, stringArray[0]);
                histogramTool.pack();
                ((Component)histogramTool).setVisible(true);
            }
            catch (Exception exception) {
                System.err.println(exception);
                System.exit(1);
            }
        } else {
            Histogram histogram = new Histogram();
            HistogramTool histogramTool = new HistogramTool(histogram, "HistogramTool");
            histogramTool.pack();
            ((Component)histogramTool).setVisible(true);
        }
    }

    public void saveHistogram() {
        block4: {
            if (this.histogram.getNumBands() == 0) {
                this.error("No histogram data to save!");
                return;
            }
            this.fileChooser.setDialogTitle("Save histogram");
            if (this.fileChooser.showSaveDialog(this) != 0) break block4;
            try {
                int n;
                File file = this.fileChooser.getSelectedFile();
                if (file.exists() && (n = JOptionPane.showConfirmDialog(this, "File will be overwritten!  Are you sure?", "File exists", 2)) != 0) {
                    return;
                }
                this.histogram.write((Writer)new FileWriter(file));
                this.fileChooser.rescanCurrentDirectory();
            }
            catch (IOException iOException) {
                this.error("Cannot open output file.");
            }
        }
    }
}

