/*
 * Decompiled with CFR 0.152.
 */
import com.pearsoneduc.ip.gui.ImageView;
import com.pearsoneduc.ip.gui.WindowMonitor;
import com.pearsoneduc.ip.io.ImageDecoder;
import com.pearsoneduc.ip.io.ImageDecoderException;
import com.pearsoneduc.ip.io.ImageFile;
import com.pearsoneduc.ip.op.ConvolutionOp;
import com.pearsoneduc.ip.op.OperationException;
import com.pearsoneduc.ip.util.IntervalTimer;
import com.pearsoneduc.ip.util.StringTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.Kernel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;

public class ConvolutionTool
extends JFrame
implements ActionListener {
    private static final String STAR_ICON = "star.gif";
    private static final String EQUALS_ICON = "equals.gif";
    private int width;
    private int height;
    private float[] kernelData;
    private int borderStrategy = 1;
    private int rescaleStrategy = 1;
    private BufferedImage inputImage;
    private KernelPane kernelPane;
    private ImageView filteredView;
    private JMenu fileMenu;
    private JMenu convolveMenu;
    private JFileChooser fileChooser = new JFileChooser(System.getProperty("user.dir"));
    private JLabel statusBar = new JLabel("Ready");
    private IntervalTimer timer = new IntervalTimer();

    public ConvolutionTool(String string, int n, int n2) throws IOException, ImageDecoderException, OperationException {
        super("ConvolutionTool: " + string);
        if (n % 2 == 0 || n2 % 2 == 0) {
            throw new OperationException("invalid kernel dimensions");
        }
        this.width = n;
        this.height = n2;
        this.kernelData = new float[n * n2];
        ImageDecoder imageDecoder = ImageFile.createImageDecoder((String)string);
        this.inputImage = imageDecoder.decodeAsBufferedImage();
        if (this.inputImage.getType() != 10) {
            throw new OperationException("invalid image type");
        }
        ImageView imageView = new ImageView(this.inputImage);
        this.filteredView = new ImageView(this.inputImage);
        this.kernelPane = new KernelPane(this.width, this.height);
        JLabel jLabel = new JLabel(new ImageIcon(this.getClass().getResource(STAR_ICON)));
        JLabel jLabel2 = new JLabel(new ImageIcon(this.getClass().getResource(EQUALS_ICON)));
        JPanel jPanel = new JPanel();
        jPanel.add(new JScrollPane((Component)imageView));
        jPanel.add(jLabel);
        jPanel.add(this.kernelPane);
        jPanel.add(jLabel2);
        jPanel.add(new JScrollPane((Component)this.filteredView));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        jPanel2.add((Component)this.statusBar, "South");
        this.setContentPane(jPanel2);
        JMenuBar jMenuBar = new JMenuBar();
        this.createFileMenu();
        this.createConvolveMenu();
        jMenuBar.add(this.fileMenu);
        jMenuBar.add(this.convolveMenu);
        this.setJMenuBar(jMenuBar);
        this.addWindowListener((WindowListener)new WindowMonitor());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Load kernel")) {
            this.loadKernel();
            this.repaint();
        } else if (string.equals("Save kernel")) {
            this.saveKernel();
            this.repaint();
        } else if (string.equals("Exit")) {
            ((Component)this).setVisible(false);
            this.dispose();
            System.exit(0);
        } else if (string.equals("Reset kernel")) {
            this.kernelPane.reset();
        } else if (string.equals("Convolve")) {
            this.convolve();
        } else if (string.equals("No operation at borders")) {
            this.borderStrategy = 1;
        } else if (string.equals("Copy border pixels")) {
            this.borderStrategy = 2;
        } else if (string.equals("Reflected indexing")) {
            this.borderStrategy = 3;
        } else if (string.equals("Circular indexing")) {
            this.borderStrategy = 4;
        } else if (string.equals("No rescaling")) {
            this.rescaleStrategy = 1;
        } else if (string.equals("Rescale max only")) {
            this.rescaleStrategy = 2;
        } else if (string.equals("Rescale min and max")) {
            this.rescaleStrategy = 3;
        }
    }

    public void addOptions(String[] stringArray, JMenu jMenu) {
        ButtonGroup buttonGroup = new ButtonGroup();
        int n = 0;
        while (n < stringArray.length) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(stringArray[n]);
            jMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            if (n == 0) {
                jRadioButtonMenuItem.setSelected(true);
            }
            ++n;
        }
    }

    public void convolve() {
        float f = 0.0f;
        int n = 0;
        while (n < this.kernelData.length) {
            this.kernelData[n] = this.kernelPane.getCoeff(n);
            f += this.kernelData[n];
            ++n;
        }
        if (f > 1.0f) {
            n = 0;
            while (n < this.kernelData.length) {
                int n2 = n++;
                this.kernelData[n2] = this.kernelData[n2] / f;
            }
        }
        Kernel kernel = new Kernel(this.width, this.height, this.kernelData);
        ConvolutionOp convolutionOp = new ConvolutionOp(kernel, this.borderStrategy, 1, this.rescaleStrategy);
        this.statusBar.setText("Convolving image...");
        this.timer.start();
        BufferedImage bufferedImage = convolutionOp.filter(this.inputImage, null);
        this.statusBar.setText("Convolution finished [" + this.timer.stop() + " sec]");
        this.filteredView.setImage(bufferedImage);
        this.filteredView.repaint();
    }

    public void createConvolveMenu() {
        this.convolveMenu = new JMenu("Convolve");
        this.convolveMenu.setMnemonic('C');
        String[] stringArray = new String[]{"Reset kernel", "Convolve"};
        char[] cArray = new char[]{'R', 'V'};
        int n = 0;
        while (n < stringArray.length) {
            JMenuItem jMenuItem = new JMenuItem(stringArray[n], cArray[n]);
            this.convolveMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            ++n;
        }
        JMenu jMenu = new JMenu("Options");
        String[] stringArray2 = new String[]{"No operation at borders", "Copy border pixels", "Reflected indexing", "Circular indexing"};
        this.addOptions(stringArray2, jMenu);
        jMenu.addSeparator();
        String[] stringArray3 = new String[]{"No rescaling", "Rescale max only", "Rescale min and max"};
        this.addOptions(stringArray3, jMenu);
        this.convolveMenu.add(jMenu);
    }

    public void createFileMenu() {
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic('F');
        String[] stringArray = new String[]{"Load kernel", "Save kernel", "Exit"};
        char[] cArray = new char[]{'L', 'S', 'X'};
        int n = 0;
        while (n < stringArray.length) {
            JMenuItem jMenuItem = new JMenuItem(stringArray[n], cArray[n]);
            jMenuItem.addActionListener(this);
            this.fileMenu.add(jMenuItem);
            ++n;
        }
    }

    public int getNumber(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == -2) {
            return (int)streamTokenizer.nval;
        }
        if (streamTokenizer.ttype == -1) {
            throw new EOFException("Kernel appears to be truncated!");
        }
        throw new IOException("Invalid kernel file!");
    }

    public void loadKernel() {
        block5: {
            this.fileChooser.setDialogTitle("Load kernel");
            if (this.fileChooser.showOpenDialog(this) != 0) break block5;
            try {
                StreamTokenizer streamTokenizer = new StreamTokenizer(new BufferedReader(new FileReader(this.fileChooser.getSelectedFile())));
                streamTokenizer.commentChar(35);
                int n = this.getNumber(streamTokenizer);
                int n2 = this.getNumber(streamTokenizer);
                this.getNumber(streamTokenizer);
                if (n != this.width || n2 != this.height) {
                    throw new IOException("Invalid kernel dimensions!");
                }
                int n3 = 0;
                while (n3 < this.kernelData.length) {
                    this.kernelPane.setCoeff(n3, this.getNumber(streamTokenizer));
                    ++n3;
                }
                this.statusBar.setText("Kernel loaded");
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.statusBar.setText("Cannot access the specified kernel file!");
            }
            catch (IOException iOException) {
                this.statusBar.setText(iOException.getMessage());
            }
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            try {
                int n = 3;
                int n2 = 3;
                if (stringArray.length > 2) {
                    n = Integer.parseInt(stringArray[1]);
                    n2 = Integer.parseInt(stringArray[2]);
                }
                ConvolutionTool convolutionTool = new ConvolutionTool(stringArray[0], n, n2);
                convolutionTool.pack();
                ((Component)convolutionTool).setVisible(true);
            }
            catch (Exception exception) {
                System.err.println(exception);
                System.exit(1);
            }
        } else {
            System.err.println("usage: java ConvolutionTool <imagefile> [<width> <height>]");
            System.exit(1);
        }
    }

    public void saveKernel() {
        block5: {
            this.fileChooser.setDialogTitle("Save kernel");
            if (this.fileChooser.showSaveDialog(this) != 0) break block5;
            try {
                int n;
                File file = this.fileChooser.getSelectedFile();
                if (file.exists() && (n = JOptionPane.showConfirmDialog(this, "File will be overwritten!  Are you sure?", "File exists", 2)) != 0) {
                    return;
                }
                PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                printWriter.println("# convolution kernel");
                printWriter.println(String.valueOf(this.width) + " " + this.height + " 0");
                int n2 = 0;
                int n3 = 0;
                while (n3 < this.height) {
                    int n4 = 0;
                    while (n4 < this.width) {
                        printWriter.print(StringTools.rightJustify((int)this.kernelPane.getCoeff(n2), (int)4));
                        ++n4;
                        ++n2;
                    }
                    printWriter.println();
                    ++n3;
                }
                printWriter.flush();
                this.fileChooser.rescanCurrentDirectory();
                this.statusBar.setText("Kernel saved");
            }
            catch (IOException iOException) {
                this.statusBar.setText(iOException.getMessage());
            }
        }
    }
}

