/*
 * Decompiled with CFR 0.152.
 */
import com.pearsoneduc.ip.gui.ImageView;
import com.pearsoneduc.ip.gui.WindowMonitor;
import com.pearsoneduc.ip.io.ImageDecoder;
import com.pearsoneduc.ip.io.ImageDecoderException;
import com.pearsoneduc.ip.io.ImageEncoder;
import com.pearsoneduc.ip.io.ImageFile;
import com.pearsoneduc.ip.op.RegionGrower;
import com.pearsoneduc.ip.util.IntervalTimer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;

public class RegionGrowingTool
extends JFrame
implements Runnable,
ActionListener {
    private static final Color SEED_COLOUR = Color.green;
    private static final int DEFAULT_THRESHOLD = 10;
    private static final int SEEDING = 1;
    private static final int GROWING = 2;
    private static final int GROWN = 3;
    private JMenu fileMenu;
    private JMenu regionMenu;
    private View view;
    private Threshold threshold = new Threshold();
    private JLabel statusBar = new JLabel(" Click on image to define seed pixels");
    private JFileChooser fileChooser = new JFileChooser(System.getProperty("user.dir"));
    private BufferedImage image;
    private RegionGrower regionGrower;
    private Thread growthThread;
    private List seedPixels = new ArrayList();
    private int connectivity = 8;
    private int status = 1;

    public RegionGrowingTool(String string) throws IOException, ImageDecoderException {
        super("RegionGrowingTool: " + string);
        ImageDecoder imageDecoder = ImageFile.createImageDecoder((String)string);
        this.image = imageDecoder.decodeAsBufferedImage();
        this.view = new View(this.image, null);
        this.statusBar.setBorder(BorderFactory.createEtchedBorder());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)((Object)this.view), "Center");
        jPanel.add((Component)this.threshold, "South");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        jPanel2.add((Component)this.statusBar, "South");
        this.setContentPane(jPanel2);
        JMenuBar jMenuBar = new JMenuBar();
        this.createFileMenu();
        this.createRegionMenu();
        jMenuBar.add(this.fileMenu);
        jMenuBar.add(this.regionMenu);
        this.setJMenuBar(jMenuBar);
        this.fileChooser.setDialogTitle("Save regions");
        this.addWindowListener((WindowListener)new WindowMonitor());
    }

    static /* synthetic */ JLabel access$2(RegionGrowingTool regionGrowingTool) {
        return regionGrowingTool.statusBar;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Save regions")) {
            if (this.status == 3) {
                this.saveRegions();
                this.repaint();
            } else {
                this.statusBar.setText(" No regions to save!");
            }
        } else if (string.equals("Exit")) {
            ((Component)this).setVisible(false);
            this.dispose();
            System.exit(0);
        } else if (string.equals("Grow regions")) {
            if (this.status == 1) {
                this.growthThread = new Thread(this);
                this.growthThread.start();
            } else {
                this.statusBar.setText(" Regions already grown/growing!");
            }
        } else if (string.equals("Back to seeds")) {
            if (this.status == 3) {
                this.view.setOverlay(null);
                this.status = 1;
                this.statusBar.setText(" Seeds reset");
            }
        } else if (string.equals("New seeds")) {
            if (this.status != 2) {
                this.seedPixels.clear();
                this.view.setOverlay(null);
                this.status = 1;
                this.statusBar.setText(" Click on image to define seed pixels");
            }
        } else if (string.equals("4-connectivity")) {
            this.connectivity = 4;
        } else if (string.equals("8-connectivity")) {
            this.connectivity = 8;
        }
    }

    public void createFileMenu() {
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic('F');
        String[] stringArray = new String[]{"Save regions", "Exit"};
        char[] cArray = new char[]{'S', 'X'};
        int n = 0;
        while (n < stringArray.length) {
            JMenuItem jMenuItem = new JMenuItem(stringArray[n], cArray[n]);
            jMenuItem.addActionListener(this);
            this.fileMenu.add(jMenuItem);
            ++n;
        }
    }

    public void createRegionMenu() {
        JMenuItem jMenuItem;
        this.regionMenu = new JMenu("Region Growing");
        this.regionMenu.setMnemonic('R');
        String[] stringArray = new String[]{"Grow regions", "Back to seeds", "New seeds"};
        char[] cArray = new char[]{'G', 'B', 'N'};
        int n = 0;
        while (n < stringArray.length) {
            jMenuItem = new JMenuItem(stringArray[n], cArray[n]);
            jMenuItem.addActionListener(this);
            this.regionMenu.add(jMenuItem);
            ++n;
        }
        jMenuItem = new JMenu("Options");
        jMenuItem.setMnemonic('O');
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("4-connectivity");
        ((JMenu)jMenuItem).add(jRadioButtonMenuItem);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("8-connectivity");
        ((JMenu)jMenuItem).add(jRadioButtonMenuItem);
        jRadioButtonMenuItem.addActionListener(this);
        jRadioButtonMenuItem.setSelected(true);
        buttonGroup.add(jRadioButtonMenuItem);
        this.regionMenu.add(jMenuItem);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            try {
                RegionGrowingTool regionGrowingTool = new RegionGrowingTool(stringArray[0]);
                regionGrowingTool.pack();
                ((Component)regionGrowingTool).setVisible(true);
            }
            catch (Exception exception) {
                System.err.println(exception);
                System.exit(1);
            }
        } else {
            System.err.println("usage: java RegionGrowingTool <imagefile>");
            System.exit(1);
        }
    }

    public void run() {
        this.status = 2;
        this.statusBar.setText(" Growing regions...");
        this.regionGrower = new RegionGrower(this.image, this.seedPixels, this.connectivity, this.threshold.getValue(), true);
        IntervalTimer intervalTimer = new IntervalTimer();
        intervalTimer.start();
        while (this.regionGrower.isNotFinished()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            this.regionGrower.grow();
            this.view.setOverlay(this.regionGrower.getStatusImage());
        }
        this.status = 3;
        this.statusBar.setText(" Region growing finished [" + intervalTimer.stop() + " sec]");
    }

    public void saveRegions() {
        block3: {
            if (this.fileChooser.showSaveDialog(this) != 0) break block3;
            try {
                int n;
                File file = this.fileChooser.getSelectedFile();
                if (file.exists() && (n = JOptionPane.showConfirmDialog(this, "File will be overwritten!  Are you sure?", "File exists", 2)) != 0) {
                    return;
                }
                ImageEncoder imageEncoder = ImageFile.createImageEncoder((String)file.getAbsolutePath());
                imageEncoder.encode(this.regionGrower.getRegionImage());
                this.fileChooser.rescanCurrentDirectory();
            }
            catch (Exception exception) {
                this.statusBar.setText(" Error: " + exception.getMessage());
            }
        }
    }

    class View
    extends ImageView {
        private BufferedImage overlay;

        public View(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
            super(bufferedImage);
            this.overlay = bufferedImage2;
            ((Component)((Object)this)).addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ View this$1;
                {
                    this.this$1 = view;
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    if (RegionGrowingTool.access$0(View.access$0(this.this$1)) == 1) {
                        Point point = mouseEvent.getPoint();
                        if (!RegionGrowingTool.access$1(View.access$0(this.this$1)).contains(point)) {
                            RegionGrowingTool.access$1(View.access$0(this.this$1)).add(point);
                            RegionGrowingTool.access$2(View.access$0(this.this$1)).setText(" Seed defined at (" + point.x + "," + point.y + ")");
                            ((Component)((Object)this.this$1)).repaint();
                        }
                    }
                }
            });
        }

        static /* synthetic */ RegionGrowingTool access$0(View view) {
            return view.RegionGrowingTool.this;
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.overlay != null) {
                graphics.drawImage(this.overlay, 0, 0, (ImageObserver)((Object)this));
            }
            if (RegionGrowingTool.this.status == 1) {
                graphics.setColor(SEED_COLOUR);
                Iterator iterator = RegionGrowingTool.this.seedPixels.iterator();
                while (iterator.hasNext()) {
                    Point point = (Point)iterator.next();
                    graphics.fillRect(point.x - 1, point.y - 1, 3, 3);
                }
            }
        }

        public void setOverlay(BufferedImage bufferedImage) {
            this.overlay = bufferedImage;
            ((Component)((Object)this)).repaint();
        }
    }

    class Threshold
    extends JPanel {
        private JTextField value = new JTextField(String.valueOf(10), 3);

        public Threshold() {
            this.setLayout(new FlowLayout());
            this.add(new JLabel("Threshold"));
            this.add(this.value);
        }

        public int getValue() {
            try {
                int n = Integer.parseInt(this.value.getText());
                return Math.max(0, Math.min(255, n));
            }
            catch (Exception exception) {
                this.value.setText(String.valueOf(10));
                return 10;
            }
        }
    }
}

