/*
 * Decompiled with CFR 0.152.
 */
import com.pearsoneduc.ip.op.GreyMapOp;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import javax.swing.JLabel;

public class GreyMapView
extends JLabel {
    int axisOffset = 15;
    int axisLength = 150;
    double scaling = (double)this.axisLength / 255.0;
    int arrowWidth = 6;
    int arrowLength = 10;
    GreyMapOp operation;
    Shape axes;
    Shape mapping;

    public GreyMapView(GreyMapOp greyMapOp) {
        this.operation = greyMapOp;
        this.axes = this.createAxes();
        this.mapping = this.createMapping();
    }

    public Shape createAxes() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 0.0f);
        generalPath.lineTo(255.0f, 0.0f);
        generalPath.moveTo(0.0f, 0.0f);
        generalPath.lineTo(0.0f, 255.0f);
        generalPath.moveTo(255.0f, 0.0f);
        generalPath.lineTo(255 - this.arrowLength, -this.arrowWidth);
        generalPath.moveTo(255.0f, 0.0f);
        generalPath.lineTo(255 - this.arrowLength, this.arrowWidth);
        generalPath.moveTo(0.0f, 255.0f);
        generalPath.lineTo(-this.arrowWidth, 255 - this.arrowLength);
        generalPath.moveTo(0.0f, 255.0f);
        generalPath.lineTo(this.arrowWidth, 255 - this.arrowLength);
        return generalPath;
    }

    public Shape createMapping() {
        GeneralPath generalPath = new GeneralPath(1, 512);
        generalPath.moveTo(0.0f, this.operation.getTableEntry(0));
        int n = 1;
        while (n < 256) {
            generalPath.lineTo(n, this.operation.getTableEntry(n));
            ++n;
        }
        return generalPath;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.axisLength + 2 * this.axisOffset, this.axisLength + 2 * this.axisOffset);
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.translate(this.axisOffset, this.axisOffset + this.axisLength);
        graphics2D.scale(this.scaling, -this.scaling);
        graphics2D.setStroke(new BasicStroke(1.5f));
        graphics2D.setPaint(Color.black);
        graphics2D.draw(this.axes);
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.setPaint(Color.red);
        graphics2D.draw(this.mapping);
    }

    public void updateView() {
        this.mapping = this.createMapping();
        this.repaint();
    }

    public void updateView(GreyMapOp greyMapOp) {
        this.operation = greyMapOp;
        this.updateView();
    }
}

