/*
 * Decompiled with CFR 0.152.
 */
import com.pearsoneduc.ip.gui.ImageView;
import com.pearsoneduc.ip.gui.WindowMonitor;
import com.pearsoneduc.ip.io.ImageDecoder;
import com.pearsoneduc.ip.io.ImageDecoderException;
import com.pearsoneduc.ip.io.ImageFile;
import com.pearsoneduc.ip.op.EqualiseOp;
import com.pearsoneduc.ip.op.ExpOp;
import com.pearsoneduc.ip.op.Histogram;
import com.pearsoneduc.ip.op.HistogramException;
import com.pearsoneduc.ip.op.InvertOp;
import com.pearsoneduc.ip.op.LinearOp;
import com.pearsoneduc.ip.op.LogOp;
import com.pearsoneduc.ip.op.SquareRootOp;
import com.pearsoneduc.ip.op.ThresholdOp;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class GreyMapTool
extends JFrame {
    public GreyMapTool(String string) throws IOException, ImageDecoderException, HistogramException {
        super("GreyMapTool: " + string);
        ImageDecoder imageDecoder = ImageFile.createImageDecoder((String)string);
        BufferedImage bufferedImage = imageDecoder.decodeAsBufferedImage();
        LinearOp linearOp = new LinearOp();
        ImageView imageView = new ImageView(bufferedImage, (BufferedImageOp)linearOp);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("linear", linearOp);
        hashtable.put("square-root", new SquareRootOp());
        hashtable.put("logarithmic", new LogOp());
        hashtable.put("exponential", new ExpOp());
        hashtable.put("inverted", new InvertOp());
        hashtable.put("thresholded", new ThresholdOp(128));
        hashtable.put("equalised", new EqualiseOp(new Histogram(bufferedImage)));
        Vector<String> vector = new Vector<String>();
        vector.addElement("linear");
        vector.addElement("square-root");
        vector.addElement("logarithmic");
        vector.addElement("exponential");
        vector.addElement("inverted");
        vector.addElement("thresholded");
        vector.addElement("equalised");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(new GreyMapPanel(imageView, hashtable, vector));
        jPanel.add(new JScrollPane((Component)imageView));
        this.setContentPane(jPanel);
        this.addWindowListener((WindowListener)new WindowMonitor());
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            try {
                GreyMapTool greyMapTool = new GreyMapTool(stringArray[0]);
                greyMapTool.pack();
                ((Component)greyMapTool).setVisible(true);
            }
            catch (Exception exception) {
                System.err.println(exception);
                System.exit(1);
            }
        } else {
            System.err.println("usage: java GreyMapTool <imagefile>");
            System.exit(1);
        }
    }
}

