/*
 * Decompiled with CFR 0.152.
 */
import com.pearsoneduc.ip.gui.ImageView;
import com.pearsoneduc.ip.op.GreyMapOp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImageOp;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GreyMapPanel
extends JPanel
implements ActionListener,
ChangeListener {
    private ImageView imageView;
    private Hashtable opSet;
    private GreyMapOp currentOp;
    private GreyMapView opView;
    private JComboBox opSelector;
    private JSlider lowSlider;
    private JSlider highSlider;

    public GreyMapPanel(ImageView imageView, Hashtable hashtable, Vector vector) {
        this.imageView = imageView;
        this.opSet = hashtable;
        this.currentOp = (GreyMapOp)this.opSet.get(vector.firstElement());
        this.opView = new GreyMapView(this.currentOp);
        this.opSelector = new JComboBox(vector);
        this.opSelector.addActionListener(this);
        this.lowSlider = new JSlider(0, 0, 255, 0);
        this.lowSlider.setMinorTickSpacing(10);
        this.lowSlider.setMajorTickSpacing(50);
        this.lowSlider.setPaintTicks(true);
        this.lowSlider.setPaintLabels(true);
        this.lowSlider.addChangeListener(this);
        this.highSlider = new JSlider(0, 0, 255, 255);
        this.highSlider.setMinorTickSpacing(10);
        this.highSlider.setMajorTickSpacing(50);
        this.highSlider.setPaintTicks(true);
        this.highSlider.setPaintLabels(true);
        this.highSlider.addChangeListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.wrapper(this.opView), "Center");
        JPanel jPanel = new JPanel(new GridLayout(3, 1));
        jPanel.add(this.wrapper(this.opSelector));
        jPanel.add(this.lowSlider);
        jPanel.add(this.highSlider);
        this.add((Component)jPanel, "South");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = ((JComboBox)actionEvent.getSource()).getSelectedItem();
        this.currentOp = (GreyMapOp)this.opSet.get(object);
        this.currentOp.computeMapping(0, 255);
        this.lowSlider.setValue(0);
        this.highSlider.setValue(255);
        this.opView.updateView(this.currentOp);
        if (this.imageView != null) {
            this.imageView.setOperation((BufferedImageOp)this.currentOp);
            this.imageView.repaint();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        int n = this.lowSlider.getValue();
        int n2 = this.highSlider.getValue();
        if (jSlider == this.lowSlider && n >= n2) {
            n = n2 - 1;
        } else if (jSlider == this.highSlider && n2 <= n) {
            n2 = n + 1;
        }
        this.currentOp.computeMapping(n, n2);
        this.opView.updateView();
        if (!jSlider.getValueIsAdjusting() && this.imageView != null) {
            this.imageView.repaint();
        }
    }

    public JPanel wrapper(JComponent jComponent) {
        JPanel jPanel = new JPanel();
        jPanel.add(jComponent);
        return jPanel;
    }
}

