/*
 * Decompiled with CFR 0.152.
 */
import com.pearsoneduc.ip.gui.ImageView;
import com.pearsoneduc.ip.gui.WindowMonitor;
import com.pearsoneduc.ip.io.ImageDecoder;
import com.pearsoneduc.ip.io.ImageDecoderException;
import com.pearsoneduc.ip.io.ImageFile;
import com.pearsoneduc.ip.op.RankFilterOp;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class RankFilterTool
extends JFrame {
    private BufferedImage inputImage;
    private ImageView filteredView;

    public RankFilterTool(String string) throws IOException, ImageDecoderException {
        super("RankFilterTool: " + string);
        ImageDecoder imageDecoder = ImageFile.createImageDecoder((String)string);
        this.inputImage = imageDecoder.decodeAsBufferedImage();
        ImageView imageView = new ImageView(this.inputImage);
        RankFilterOp rankFilterOp = new RankFilterOp(5, 3, 3);
        this.filteredView = new ImageView(rankFilterOp.filter(this.inputImage, null));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(new JScrollPane((Component)imageView));
        jPanel.add(new Controls());
        jPanel.add(new JScrollPane((Component)this.filteredView));
        this.setContentPane(jPanel);
        this.addWindowListener((WindowListener)new WindowMonitor());
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            try {
                RankFilterTool rankFilterTool = new RankFilterTool(stringArray[0]);
                rankFilterTool.pack();
                ((Component)rankFilterTool).setVisible(true);
            }
            catch (Exception exception) {
                System.err.println(exception);
                System.exit(1);
            }
        } else {
            System.err.println("usage: java RankFilterTool <imagefile>");
            System.exit(1);
        }
    }

    class Controls
    extends JPanel
    implements ActionListener {
        private BufferedImageOp[] op = new BufferedImageOp[9];

        public Controls() {
            JRadioButton[] jRadioButtonArray = new JRadioButton[9];
            ButtonGroup buttonGroup = new ButtonGroup();
            this.setLayout(new GridLayout(10, 1));
            this.add(new JLabel("Rank"));
            int n = 0;
            while (n < 9) {
                this.op[n] = new RankFilterOp(n + 1, 3, 3);
                jRadioButtonArray[n] = new JRadioButton(String.valueOf(n + 1), false);
                jRadioButtonArray[n].addActionListener(this);
                buttonGroup.add(jRadioButtonArray[n]);
                this.add(jRadioButtonArray[n]);
                ++n;
            }
            jRadioButtonArray[4].setSelected(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = Integer.parseInt(actionEvent.getActionCommand());
            RankFilterTool.this.filteredView.setImage(this.op[n - 1].filter(RankFilterTool.this.inputImage, null));
            RankFilterTool.this.filteredView.repaint();
        }
    }
}

