/*
 * Decompiled with CFR 0.152.
 */
import com.awl.ip.gui.ImageView;
import com.awl.ip.gui.WindowMonitor;
import com.awl.ip.io.ImageDecoder;
import com.awl.ip.io.ImageDecoderException;
import com.awl.ip.io.ImageEncoder;
import com.awl.ip.io.ImageEncoderException;
import com.awl.ip.io.ImageFile;
import com.awl.ip.util.StringTools;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Hashtable;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JPEGTool
extends JFrame
implements ChangeListener,
ActionListener {
    private static final float DEFAULT_QUALITY = 0.5f;
    private BufferedImage inputImage;
    private int width;
    private int height;
    private JPEGEncodeParam parameters;
    private float compressionRatio;
    private float rmsError;
    private BufferedImage outputImage;
    private ImageView outputView;
    private JSlider qualitySlider;
    private NumberFormat number = new DecimalFormat("0.000");
    private Font fixedFont = new Font("Monospaced", 0, 12);
    private DataPanel ratio = new DataPanel("Compression ratio ", 0.0f);
    private DataPanel error = new DataPanel("RMS Error ", 0.0f);
    private JFileChooser fileChooser = new JFileChooser(System.getProperty("user.dir"));

    public JPEGTool(String string) throws IOException, ImageDecoderException {
        super("JPEGTool: " + string);
        this.readImage(string);
        this.compressImage(0.5f);
        ImageView imageView = new ImageView(this.inputImage);
        this.outputView = new ImageView(this.outputImage);
        JTabbedPane jTabbedPane = new JTabbedPane(3);
        jTabbedPane.add((Component)new JScrollPane((Component)imageView), "input");
        jTabbedPane.add((Component)new JScrollPane((Component)this.outputView), "output");
        JPanel jPanel = this.createControlPane();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jTabbedPane, "Center");
        jPanel2.add((Component)jPanel, "South");
        this.setContentPane(jPanel2);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.createMenu());
        this.setJMenuBar(jMenuBar);
        this.addWindowListener((WindowListener)new WindowMonitor());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Save output")) {
            this.saveImage("Save output image", this.outputImage);
        } else if (string.equals("Save difference")) {
            this.saveImage("Save difference image", this.getDifferenceImage());
        } else if (string.equals("Exit")) {
            ((Component)this).setVisible(false);
            this.dispose();
            System.exit(0);
        }
    }

    public void compressImage(float f) throws IOException {
        this.parameters.setQuality(f, false);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)byteArrayOutputStream, (JPEGEncodeParam)this.parameters);
        jPEGImageEncoder.encode(this.inputImage);
        this.computeRatio(byteArrayOutputStream.size());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)byteArrayInputStream);
        this.outputImage = jPEGImageDecoder.decodeAsBufferedImage();
        this.computeError();
    }

    public void computeError() {
        WritableRaster writableRaster = this.inputImage.getRaster();
        WritableRaster writableRaster2 = this.outputImage.getRaster();
        double d = 0.0;
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                double d2 = writableRaster.getSample(n2, n, 0) - writableRaster2.getSample(n2, n, 0);
                d += d2 * d2;
                ++n2;
            }
            ++n;
        }
        this.rmsError = (float)Math.sqrt(d / (double)(this.width * this.height));
        this.error.updateText(this.rmsError);
    }

    public void computeRatio(int n) {
        this.compressionRatio = (float)this.width * (float)this.height / (float)n;
        this.ratio.updateText(this.compressionRatio);
    }

    public JPanel createControlPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.createQualitySlider();
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.qualitySlider);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.ratio);
        jPanel3.add(this.error);
        jPanel.add((Component)jPanel3, "South");
        return jPanel;
    }

    public JMenu createMenu() {
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('F');
        String[] stringArray = new String[]{"Save output", "Save difference", "Exit"};
        char[] cArray = new char[]{'O', 'D', 'X'};
        int n = 0;
        while (n < stringArray.length) {
            JMenuItem jMenuItem = new JMenuItem(stringArray[n], cArray[n]);
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            ++n;
        }
        return jMenu;
    }

    public void createQualitySlider() {
        this.qualitySlider = new JSlider(0, 100, 50);
        this.qualitySlider.setMajorTickSpacing(20);
        this.qualitySlider.setMinorTickSpacing(5);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        int n = 0;
        while (n <= 100) {
            hashtable.put(new Integer(n), new JLabel(String.valueOf((float)n / 100.0f)));
            n += 20;
        }
        this.qualitySlider.setLabelTable(hashtable);
        this.qualitySlider.setPaintTicks(true);
        this.qualitySlider.setPaintLabels(true);
        CompoundBorder compoundBorder = new CompoundBorder(new TitledBorder("Quality"), new EmptyBorder(5, 10, 5, 10));
        this.qualitySlider.setBorder(compoundBorder);
        this.qualitySlider.addChangeListener(this);
    }

    public void error(String string) {
        JOptionPane.showMessageDialog(this, string, "Error", 0);
    }

    public BufferedImage getDifferenceImage() {
        WritableRaster writableRaster = this.inputImage.getRaster();
        WritableRaster writableRaster2 = this.outputImage.getRaster();
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 10);
        WritableRaster writableRaster3 = bufferedImage.getRaster();
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                writableRaster3.setSample(n2, n, 0, Math.abs(writableRaster.getSample(n2, n, 0) - writableRaster2.getSample(n2, n, 0)));
                ++n2;
            }
            ++n;
        }
        return bufferedImage;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            try {
                JPEGTool jPEGTool = new JPEGTool(stringArray[0]);
                jPEGTool.pack();
                ((Component)jPEGTool).setVisible(true);
            }
            catch (Exception exception) {
                System.err.println(exception);
                System.exit(1);
            }
        } else {
            System.err.println("usage: java JPEGTool <infile>");
            System.exit(1);
        }
    }

    public void readImage(String string) throws IOException, ImageDecoderException {
        ImageDecoder imageDecoder = ImageFile.createImageDecoder((String)string);
        this.inputImage = imageDecoder.decodeAsBufferedImage();
        this.width = this.inputImage.getWidth();
        this.height = this.inputImage.getHeight();
        this.parameters = JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)this.inputImage);
    }

    public void saveImage(String string, BufferedImage bufferedImage) {
        block4: {
            int n;
            this.fileChooser.setDialogTitle(string);
            if (this.fileChooser.showSaveDialog(this) != 0) break block4;
            File file = this.fileChooser.getSelectedFile();
            if (file.exists() && (n = JOptionPane.showConfirmDialog(this, "File will be overwritten!  Are you sure?", "File exists", 2)) != 0) {
                return;
            }
            try {
                ImageEncoder imageEncoder = ImageFile.createImageEncoder((String)file.getAbsolutePath());
                imageEncoder.encode(bufferedImage);
                this.fileChooser.rescanCurrentDirectory();
            }
            catch (ImageEncoderException imageEncoderException) {
                this.error("Cannot determine an appropriate image format!");
            }
            catch (IOException iOException) {
                this.error("Error writing image!");
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        block2: {
            if (this.qualitySlider.getValueIsAdjusting()) break block2;
            try {
                float f = (float)this.qualitySlider.getValue() / 100.0f;
                this.compressImage(f);
                this.outputView.setImage(this.outputImage);
                this.outputView.repaint();
            }
            catch (Exception exception) {}
        }
    }

    class DataPanel
    extends JPanel {
        private JLabel label = new JLabel();

        public DataPanel(String string, float f) {
            this.add(new JLabel(string));
            this.label.setFont(JPEGTool.this.fixedFont);
            this.label.setForeground(Color.black);
            this.updateText(f);
            this.add(this.label);
        }

        public void updateText(float f) {
            this.label.setText(StringTools.rightJustify((String)JPEGTool.this.number.format(f), (int)7));
        }
    }
}

