#include <stdio.h>
#include <stdlib.h>
#include <string.h>

const int MAXCITIES = 1000;

class Path {
public:
    int length;			
    int city[MAXCITIES];
    int visited;			
  /* Array city[] is a permutation of all cities.
   * city[0]..city[visited-1] is the current partial path;
   * city[visited]..city[NumCities-1] are the cities not yet in the path 
   */
    Path();			
    void Set (int len, int *cit, int vis);
    void Print();
};


enum {PUT_PATH_TAG, BEST_PATH_TAG, GET_PATH_TAG, UPDATE_BEST_PATH_TAG, DONE_TAG, REPLY_PATH_TAG};

// This is the payload of PUT_PATH_TAG, GOOD_PATH_TAG, and REPLY_PATH_TAG messages
struct Msg_t {
    int length;
    int city[MAXCITIES];
    int visited;
};

typedef struct Point TPoint;
struct Point {
    double x, y;
};

TPoint pt[MAXCITIES];

const int MSGSIZE = sizeof(Msg_t)/sizeof(int);