#include <stdlib.h>
#include "list.h"

ListElement::ListElement(void *itemPtr, int sortKey) {
    item = itemPtr;
    key = sortKey;
    next = NULL;	
}

List::List() { 
    first = last = NULL; 
}

List::~List() { 
    while (Remove(NULL) != NULL);	
}


bool List::IsEmpty() { 
    if (first == NULL) {
        return true;
	} else {
	    return false; 
	}
}

void List::Insert(void *item, int sortKey) {
    ListElement *element = new ListElement(item, sortKey);
    ListElement *ptr;

    if (IsEmpty()) {	
		//If list is empty, put
        first = element;
        last = element;
    } else if (sortKey < first->key) {	
		element->next = first;
	    first = element;
    } else {		
        for (ptr = first; ptr->next != NULL; ptr = ptr->next) {
            if (sortKey < ptr->next->key) {
		        element->next = ptr->next;
	            ptr->next = element;
		        return;
	        }
	    }
	    last->next = element;		
	    last = element;
    }
}

void *List::Remove(int *keyPtr) {
    ListElement *element = first;
    void *thing;

    if (IsEmpty()) {
	    return NULL;
	}

    thing = first->item;
    if (first == last) {	
        first = NULL;
        last = NULL;
    } else {
        first = element->next;
    }
    if (keyPtr != NULL) {
        *keyPtr = element->key;
	}
    delete element;
    return thing;
}
