#ifndef _DIST_COMMON_H_
#define _DIST_COMMON_H_

#include <stdint.h>
#include <math.h>

typedef uint32_t uintptr32_t;

// Representation of a point. sizeof(POINT) is 8 bytes.
typedef struct _POINT {
  float x;
  float y;
} POINT;

#define NUM_POINTS 64

// Calculates square of a number
inline float sqrf(float a) {
  return a * a;
}

// Calculates distance between 2 points
inline float distf(POINT *p1, POINT *p2) {
  return sqrt(sqrf(p2->x - p1->x) + sqrf(p2->y - p1->y));
}

// Some alignment macros
#define QWORD_ALIGNED __attribute__((aligned(16)));
#define CACHE_ALIGNED __attribute__((aligned(128)));

#endif
